% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rehshape.R
\name{rehshape}
\alias{rehshape}
\title{Transform processed remify objects to different formats}
\usage{
rehshape(
  data,
  output_format = c("relevent-rem", "relevent-rem.dyad"),
  ncores = 1L,
  optional_arguments = NULL
)
}
\arguments{
\item{data}{an object of class 'remify' (see function \code{remify::remify()}).}

\item{output_format}{a character indicating the output format which the input data has to be converted to. It can assume two values: \code{"relevent-rem"} , \code{"relevent-rem.dyad"}. Default value is \code{"relevent-rem"}.}

\item{ncores}{number of cores used to parallelize internal algorithms}

\item{optional_arguments}{vector of arguments names from relevent::rem or relevent::rem.dyad() that the user might want to process and have in the output object of rehshape (e.g., the pre-computed structures required by relevent::rem.dyad)}
}
\value{
an object of class specified in the \code{output_format} argument. The output class object 'relevent-rem' contains a list of objects named after the arguments of the function \code{relevent::rem()}: 'eventlist' (mandatory), 'supplist' (optional), 'timing'(mandatory). The output class object 'relevent-rem.dyad' contains a list of objects named after the arguments of the function \code{relevent::rem.dyad()}: 'edgelist' (mandatory), 'n' (mandatory), 'ordinal'(optional).
}
\description{
A function that transforms a \code{remify} object into one of the possible formats that suit external packages. The function can convert, at the moment, the data structure from an object of class \code{remify} to a data structure required by the function \code{relevent::rem()} or by the function \code{relevent::rem.dyad()} from the '\href{https://CRAN.R-project.org/package=relevent}{relevent}' package (Butts, C.T. 2023).
}
\examples{

# processing the random network 'randomREH'
library(remify)
data(randomREH)
reh <- remify(edgelist = randomREH$edgelist,
              model = "tie",
              riskset = "manual",
              omit_dyad = randomREH$omit_dyad)

# convert 'remify' object to output_format = "relevent-rem"
relevent_rem_obj <- rehshape(data = reh, output_format = "relevent-rem")

str(relevent_rem_obj) 

# convert 'remify' object to output_format = "relevent-rem.dyad"
relevent_rem.dyad_obj <- rehshape(data = reh, output_format = "relevent-rem.dyad")

summary(relevent_rem.dyad_obj)

}
