% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{summary.block_lm}
\alias{summary.block_lm}
\title{Summarizing block regression.}
\usage{
\method{summary}{block_lm}(object, ...)
}
\arguments{
\item{object}{An object of class "\code{block_lm}", usually, a result of a
call to \code{\link{build_model}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function computes and returns a named list of summary statistics
  of the fitted linear models given in \code{model}. The list has the
  following elements:
\tabular{ll}{
  \code{formulas} \tab A list of the regression formulas used for each block.
  \cr
  \code{residuals} \tab A matrix with quantiles of the residuals for each
  model.\cr
  \code{coefficients} \tab A list with a matrix of coefficients for each
  model, as well as the standard error, t-statistic, and p-value.\cr
  \code{overall} \tab A data frame with information about the overall models,
  including the multiple R-squared value; adjusted R-squared; F-statistic,
  degrees of freedom, and p-value for each overall model; and the delta
  R-squared (change in R-squared) and its associated F-statistic and p-value.
  \cr
}
}
\description{
\code{summary} method for class "\code{block_lm}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2)
}
\seealso{
\code{\link{build_model}}, \code{\link{print.block_lm_summary}}
}

