% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_geneSymbol.R
\name{refseq_geneSymbol}
\alias{refseq_geneSymbol}
\title{Get the gene symbol}
\usage{
refseq_geneSymbol (id, db)
}
\arguments{
\item{id}{A character string of the XP or XM id.}

\item{db}{A character string of the "nuccore" or "protein" database.}
}
\value{
A character vector containing the gene symbol corresponding to the especified accession as \code{id}.
}
\description{
\code{refseq_geneSymbol()} Returns the gene symbol from a single Gene id. accession.
}
\examples{
# Get the gene symbol from a set of XM accessions
xm = c("XM_004487701", "XM_004488493")
sapply(xm, function(x) refseq_geneSymbol (x, db = "nuccore"), USE.NAMES = FALSE)

# Get the gene symbol from a set of XP accessions
xp = c("XP_004487758")
sapply(xp, function(x) refseq_geneSymbol (x, db = "protein"), USE.NAMES = FALSE)

}
\seealso{
\code{\link{refseq_XMfromXP}} to obtain the XM ids that encode a set of XP ids.

\code{\link{refseq_XPfromXM}} to obtain the XP ids encoded by a set of XM ids.
}
\author{
Jose V. Die
}
