% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_skew}
\alias{comp_skew}
\title{Calculate Skew Compactness}
\usage{
comp_skew(plans, shp, epsg = 3857, ncores = 1)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{ncores}{numeric. Number of cores to use. Default is 1.}
}
\value{
numeric vector
}
\description{
Skew is defined as the ratio of the radii of the largest inscribed circle with
the smallest bounding circle. Scores are bounded between 0 and 1, where 1 is
most compact.
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_skew(plans = nh$r_2020, shp = nh)

# Or many plans:
\donttest{
# slower, beware!
comp_skew(plans = nh_m[, 3:5], shp = nh)
}
}
\references{
S.N. Schumm. 1963. Sinuosity of alluvial rivers on the Great Plains.
Bulletin of the Geological Society of America, 74. 1089-1100.
}
\concept{compactness}
