% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{redist.map}
\alias{redist.map}
\title{Creates a map with optional graph overlay}
\usage{
redist.map(
  shp = NULL,
  district_membership = NULL,
  centroids = TRUE,
  edges = TRUE,
  drop = FALSE,
  title = ""
)
}
\arguments{
\item{shp}{A SpatialPolygonsDataFrame or sf object. Required.}

\item{district_membership}{A numeric vector with one row for each precinct in shp. 
Used to color the districts. Default is \code{NULL}.  Optional.}

\item{centroids}{A logical indicating if centroids should be plotted. Default is \code{TRUE}.}

\item{edges}{A logical indicating if edges should connect adjacent centroids. Default is \code{TRUE}.}

\item{drop}{A logical indicating if edges that cross districts should be dropped. Default is \code{FALSE}.}

\item{title}{A string title of plot. Defaults to empty string. Optional.}
}
\value{
ggplot map
}
\description{
Creates a map with optional graph overlay
}
\examples{
\dontrun{
library(redist)
data("fl25")
data("algdat.p10")
cds <- algdat.p10$cdmat[,100]
redist.map(shp = fl25, district_membership = cds)
}

}
