% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessionise.R
\name{sessionise}
\alias{sessionise}
\title{Reconstruct sessions (experimental)}
\usage{
sessionise(x, timestamp, user_id, threshold = 3600)
}
\arguments{
\item{x}{a data.frame of events.}

\item{timestamp}{the name of the column of \code{x} containing timestamps,
which should be (either) a representation of the number of seconds, or a
POSIXct or POSIXlt date/time object. If it is neither, \code{\link{strptime}}
can be used to convert most representations of date-times into POSIX formats.}

\item{user_id}{the name of the column of \code{x} containing unique user IDs.}

\item{threshold}{the number of seconds to use as the intertime threshold -
the time that can elapse between two events before the second is considered
part of a new session. Set to 3600 (one hour) by default.}
}
\value{
\code{x}, ordered by userID and timestamp, with two new columns -
\code{session_id} (containing a unique ID for the session a row is in)
and \code{delta} (containing the time elapsed between that row's event,
and the previous event, if they were both in the same session).
}
\description{
\code{sessionise} takes a data.frame of events
(including timestamps and user IDs) and sessionises them,
returning the same data.frame but with two additional columns -
one containing a unique session ID, and one the time difference between
successive events in the same session.
}
\examples{
# Take a dataset with URLs and similar metadata and sessionise it -
# retaining that metadata

data("session_dataset")
sessionised_data <- sessionise(x = session_dataset,
                              timestamp = timestamp,
                              user_id = uuid,
                              threshold = 1800)

}
\seealso{
\code{\link{bounce_rate}}, \code{\link{time_on_page}},
\code{\link{session_length}} and \code{\link{session_count}} - common metrics
that can be calculated with a sessionised dataset.
}

