% Generated by roxygen2 (4.0.2): do not edit by hand
\name{padding_value}
\alias{padding_value}
\title{automatically generate plausible padding values}
\usage{
padding_value(sessions, method, fun, ...)
}
\arguments{
\item{sessions}{a list of sessions, generated with \code{\link{sessionise}}}

\item{method}{the method to use to generate the value. Options are "geometric mean",
"arithmetic mean", "median" or "other" (see below).}

\item{fun}{the function to apply to generate \code{\link{padding_value}}, in the
event that you choose "other" for \code{method}.}

\item{...}{additional arguments to pass to fun, or the function called by the
method.}
}
\description{
\code{\link{padding_value}} is designed to automatically generate
acceptable values for the \code{padding_value} argument in \code{\link{session_length}}.
It does this by applying a statistical function to the range of inter-event values within
the dataset.
}
\examples{
#Generate a padding value based on the geometric mean of the known times between events
data("session_dataset")
session_dataset$timestamp <- to_seconds(x = session_dataset$timestamp, format = "\%Y\%m\%d\%H\%M\%S")
events_by_user <- split(session_dataset$timestamp, session_dataset$UUID)
sessions <- sessionise(events_by_user)
padding_val <- padding_value(sessions, "geometric mean")
padding_val
#41.07547
}

