% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_survdat.R
\name{integrate_survdat}
\alias{integrate_survdat}
\title{Integrate area under curve for single arm}
\usage{
integrate_survdat(dat, tau, alpha = 0.05)
}
\arguments{
\item{dat}{Data frame of time-to-event data which MUST have the columns
'time' and 'status' exactly}

\item{tau}{The cutoff time, a scalar}

\item{alpha}{Level for confidence interval}
}
\value{
data.frame with rows for RMST and RMTL and columnns for estimate, std err, pvalue, and CI
}
\description{
Calculate nonparametric RMST for a single arm up to tau for data.frame with time and status
}
\examples{

time <- rnorm(100)
status <- rbinom(n=100, size=1, prob=0.5)
dat <- data.frame(time=time, status=status)
integrate_survdat(dat=dat, tau=2)

}
