% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{set.lang}
\alias{set.lang}
\title{Assign Stata Language Labels}
\usage{
set.lang(dat, lang = NA, generate.factors = FALSE)
}
\arguments{
\item{dat}{\emph{data.frame.} Data.frame created by \code{read.dta13}.}

\item{lang}{\emph{character.} Label language. Default language defined by \code{\link{get.lang}} is used if NA}

\item{generate.factors}{\emph{logical.} If \code{TRUE}, missing factor levels are generated.}
}
\value{
Returns a data.frame with value labels in language "lang".
}
\description{
Changes default label language for a dataset.
}
\examples{
dat <- read.dta13(system.file("extdata/statacar.dta", package="readstata13"))
get.lang(dat)
varlabel(dat)

# set German label
datDE <- set.lang(dat, "de")
get.lang(datDE)
varlabel(datDE)
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}

