% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.reSurv}
\alias{plot.reSurv}
\title{Produce Event Plots}
\usage{
\method{plot}{reSurv}(x, data, order = TRUE, return.grob = FALSE,
  control = list(), ...)
}
\arguments{
\item{x}{an object of class \code{reSurv}, usually returned by the \code{reSurv} function.}

\item{data}{an optional data frame in which to interpret the variables occurring in the "formula".}

\item{order}{an optional logical value. If "TRUE", the event plot is sorted by the terminal times; the default value is TRUE.}

\item{return.grob}{an optional logical value. If "TRUE", a \code{ggplot2} plot grob will be returned.}

\item{control}{a list of control parameters.}

\item{...}{for future developments.}
}
\description{
Plot the event plot for an \code{reSurv} object.
}
\details{
The argument \code{control} consists of options with argument defaults to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject".}
  \item{title}{customizable title, default value is "Recurrent event plot".}
  \item{terminal.name}{customizable label for terminal event, default value is "Terminal event".}
  \item{recurrent.name}{customizable label for recurrent event, default value is "Recurrent event plot".}
  \item{recurrent.types}{customizable label for recurrent event type, default value is NULL.}
  \item{alpha}{controls the transparency of points.}
}
}
\examples{
data(readmission)
reObj <- with(subset(readmission, id <= 10), reSurv(t.stop, event, death, id))
## Default labels
plot(reObj)
plot(reObj, order = FALSE)
## User specified labels
plot(reObj, control = list(xlab = "User xlab", ylab = "User ylab", title = "User title"))

## With multiple hypothetical event types
set.seed(1)
reObj2 <- with(readmission, reSurv(t.stop, event * sample(1:3, 861, TRUE), death, id))
plot(reObj2)

## With multiple hypothetical event types
set.seed(1)
reObj2 <- with(readmission, reSurv(t.stop, event * sample(1:3, 861, TRUE), death, id))
plot(reObj2)
}
\seealso{
\code{\link{reSurv}}
}
\keyword{plot.reSurv}
