% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.stand}
\alias{readDWD.stand}
\title{read subdaily/standard_format dwd data}
\usage{
readDWD.stand(
  file,
  fast = TRUE,
  fileEncoding = "latin1",
  formIndex = formatIndex,
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/subdaily_standard_format_kl_10381_00_akt.txt or
DWDdata/subdaily_standard_format_kl_10381_bis_1999.txt.gz}

\item{fast}{Logical: use \code{\link[readr:read_fwf]{readr::read_fwf()}} instead of \code{\link[=read.fwf]{read.fwf()}}?
Takes 0.1 instead of 20 seconds but requires package to be installed.
if fast=TRUE, \code{fileEncoding} is ignored.
DEFAULT: TRUE}

\item{fileEncoding}{\code{\link[=read.table]{read.table()}} file encoding.
DEFAULT: "latin1" (potentially needed on Linux,
optional but not hurting on windows)}

\item{formIndex}{Single object: Index used to select column widts and NA values.
To use a current / custom index, see the source code of
\code{\link[=updateIndexes]{updateIndexes()}} at
\url{https://github.com/brry/rdwd/blob/master/R/updateIndexes.R}.
DEFAULT: \code{\link{formatIndex}}}

\item{quiet}{Suppress subfunction name message?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=read.fwf]{read.fwf()}} or \code{\link[readr:read_fwf]{readr::read_fwf()}}}
}
\value{
data.frame with column names as per \code{\link{formatIndex}}.
"Q"-columns have "_parameter" appended to their name. A "Date" column has been added.
NA-indicators have been processed into NAs.
}
\description{
read subdaily/standard_format dwd data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
All other observational data at \code{\link{dwdbase}} can be read
with \code{\link[=readDWD.data]{readDWD.data()}}, except for the multi_annual and
subdaily/standard_format data.
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests

link <- selectDWD(id=10381, res="subdaily", var="standard_format", per="r")
file <- dataDWD(link, dir=localtestdir(), read=FALSE)
sf <- readDWD(file)

sf2 <- readDWD(file, fast=FALSE) # 20 secs!
stopifnot(all.equal(sf, sf2))

plot(sf$Date, sf$SHK, type="l")

# Plot all columns:
if(FALSE){ # not run in any automated testing
tmp <- tempfile(fileext=".pdf")
char2fact <- function(x)
 {
 if(all(is.na(x))) return(rep(-9, len=length(x)))
 if(!is.numeric(x)) as.factor(x) else x
 }
pdf(tmp, width=9)
par(mfrow=c(2,1),mar=c(2,3,2,0.1), mgp=c(3,0.7,0), las=1)
for(i in 3:ncol(sf)-1) plot(sf$Date, char2fact(sf[,i]), type="l", main=colnames(sf)[i], ylab="")
dev.off()
berryFunctions::openFile(tmp)
}
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2019
}
