% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lldist.R
\name{lldist}
\alias{lldist}
\alias{maxlldist}
\title{distance between lat-long coordinates}
\usage{
lldist(lat, long, data, r = 6371, i = 1L)

maxlldist(lat, long, data, r = 6371, fun = max, each = TRUE, ...)
}
\arguments{
\item{lat, long}{Latitude (North/South) and longitude (East/West) coordinates in decimal degrees}

\item{data}{Optional: data.frame with the columns \code{lat} and \code{long}}

\item{r}{radius of the earth. Could be given in miles. DEFAULT: 6371 (km)}

\item{i}{Integer: Index element against which all coordinate pairs
are computed. DEFAULT: 1}

\item{fun}{Function to be applied. DEFAULT: \code{\link[=max]{max()}}}

\item{each}{Logical: give max dist to all other points for each point separately?
If FALSE, will return the maximum of the complete distance matrix,
as if \code{max(maxlldist(y,x))}. For examples, see
\href{https://github.com/brry/OSMscale/blob/master/R/maxEarthDist.R#L14-L33}{OSMscale::maxEarthDist}
DEFAULT: TRUE}

\item{\dots}{Further arguments passed to fun, like na.rm=TRUE}
}
\value{
Vector with distance(s) in km (or units of \code{r}, if \code{r} is changed)
}
\description{
Great-circle distance between points at lat-long coordinates.
Mostly a copy of OSMscale::earthDist Version 0.5.3 (2017-04-19).
\url{https://github.com/brry/OSMscale/blob/master/R/earthDist.R#L57-L102}.
Copied manually to avoid dependency hell.
Does not check coordinates. Not exported.
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2016 + Jan 2017.
Angle formula from Diercke Weltatlas 1996, Page 245
}
\keyword{spatial}
