% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD}
\alias{readDWD}
\title{Process data from the DWD CDC FTP Server}
\usage{
readDWD(file, progbar = TRUE, fread = FALSE, varnames = FALSE,
  format = NA, tz = "GMT", dividebyten = TRUE,
  meta = grepl(".txt$", file), multia = grepl("Standort.txt$", file),
  binary = grepl(".tar.gz$", file), raster = grepl(".asc.gz$", file),
  asc = grepl(".tar$", file), ...)
}
\arguments{
\item{file}{Char (vector): name(s) of the file(s) downloaded with 
\code{\link{dataDWD}},
e.g. "~/DWDdata/tageswerte_KL_02575_akt.zip" or
"~/DWDdata/RR_Stundenwerte_Beschreibung_Stationen.txt"}

\item{progbar}{Logical: present a progress bar with estimated remaining time?
If missing and length(file)==1, progbar is internally set to FALSE.
DEFAULT: TRUE}

\item{fread}{Logical (vector): read fast? See \code{\link{readDWD.data}}.
DEFAULT: FALSE (some users complain it doesn't work on their PC)}

\item{varnames}{Logical (vector): Expand column names? 
See \code{\link{readDWD.data}}. DEFAULT: FALSE}

\item{format, tz}{Format and time zone of time stamps, see \code{\link{readDWD.data}}}

\item{dividebyten}{Logical (vector): Divide the values in raster files by ten?
Used in \code{\link{readDWD.raster}} and \code{\link{readDWD.asc}}.
DEFAULT: TRUE}

\item{meta}{Logical (vector): is the \code{file} a meta file (Beschreibung.txt)?
See \code{\link{readDWD.meta}}.
DEFAULT: TRUE for each file ending in ".txt"}

\item{multia}{Logical (vector): is the \code{file} a multi_annual file?
Overrides \code{meta}, so set to FALSE manually if 
\code{\link{readDWD.meta}} needs to be called on a file ending
with "Standort.txt". See \code{\link{readDWD.multia}}.
DEFAULT: TRUE for each file ending in "Standort.txt"}

\item{binary}{Logical (vector): does the \code{file} contain binary files?
See \code{\link{readDWD.binary}}.
DEFAULT: TRUE for each file ending in ".tar.gz"}

\item{raster}{Logical (vector): does the \code{file} contain a raster file?
See \code{\link{readDWD.raster}}.
DEFAULT: TRUE for each file ending in ".asc.gz"}

\item{asc}{Logical (vector): does the \code{file} contain asc files?
See \code{\link{readDWD.asc}}.
DEFAULT: TRUE for each file ending in ".tar"}

\item{\dots}{Further arguments passed to the internal \code{readDWD.*} 
functions and from those to the underlying reading functions
documented in each internal function.}
}
\value{
Invisible data.frame of the desired dataset, 
        or a named list of data.frames if length(file) > 1.
        \code{\link{readDWD.binary}} returns a vector, 
        \code{\link{readDWD.raster}} and \code{\link{readDWD.asc}} 
        return raster objects instead of data.frames.
}
\description{
Read climate data that was downloaded with \code{\link{dataDWD}}.
The data is unzipped and subsequently, the file is read, processed and
returned as a data.frame.\cr
New users are advised to set \code{varnames=TRUE} to obtain more informative
column names.\cr\cr
\code{readDWD} will call internal (but documented) functions depending on the
arguments \code{meta, binary, raster, multia, asc}:\cr
to read observational data: \code{\link{readDWD.data},
         \link{readDWD.meta}, \link{readDWD.multia}}\cr
to read interpolated gridded data: \code{\link{readDWD.binary},
         \link{readDWD.raster}, \link{readDWD.asc}}\cr
Not all arguments to \code{readDWD} are used for all functions, e.g. 
\code{fread} is used only by \code{.data}, while \code{dividebyten} 
is used in \code{.raster} and \code{.asc}.\cr\cr
\code{file} can be a vector with several filenames. Most other arguments can
also be a vector and will be recycled to the length of \code{file}.
}
\examples{
# see dataDWD

}
\seealso{
\code{\link{dataDWD}}, \code{\link{readVars}}, 
         \code{\link{readMeta}}, \code{\link{selectDWD}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jul-Oct 2016, Winter 2018/19
}
\keyword{chron}
\keyword{file}
