% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_get_records.R
\name{dr_get_records}
\alias{dr_get_records}
\title{Download metadata for individual Dryad id's}
\usage{
dr_get_records(ids, prefix = "oai_dc", as = "df", ...)
}
\arguments{
\item{ids}{Dryad identifier, i.e. oai:datadryad.org:10255/dryad.8820}

\item{prefix}{A character string to specify the metadata format in OAI-PMH
requests issued to the repository. The default (\code{"oai_dc"})
corresponds to the mandatory OAI unqualified Dublin Core metadata schema.}

\item{as}{(character) What to return. One of "df" (for data.frame;
default), "list", or "raw" (raw text)}

\item{...}{Curl debugging options passed on to \code{httr::GET}}
}
\value{
XML character string, data.frame, or list, depending on what
requested witht the \code{as} parameter
}
\description{
Download metadata for individual Dryad id's
}
\examples{
\dontrun{
dr_get_records(ids = 'oai:datadryad.org:10255/dryad.8820')
handles <- c('10255/dryad.36217', '10255/dryad.86943', '10255/dryad.84720',
  '10255/dryad.34100')
ids <- paste0('oai:datadryad.org:', handles)
dr_get_records(ids)
}
}
