% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drop_history.R
\name{drop_history}
\alias{drop_history}
\title{Obtains metadata for all available revisions of a file, including the current
revision.}
\usage{
drop_history(path = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{This is required The path to the new folder to create relative to
root.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}
}
\description{
Only revisions up to thirty days old are available (or more if the Dropbox
user has Extended Version History). You can use the revision number in
conjunction with the /restore call to revert the file to its previous state.
}
\examples{
\dontrun{
write.csv(iris, file = "iris.csv")
drop_upload("iris.csv")
write.csv(iris[iris$Species == "setosa", ], file = "iris.csv")
drop_upload("iris.csv")
drop_history("iris.csv")
}
}

