% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-powermean.R
\docType{class}
\name{powermean-class}
\alias{powermean-class}
\title{powermean-class}
\description{
Container for class \code{powermean}.
}
\section{Fields}{

\describe{
\item{\code{output}}{object of class \code{tibble}, with columns:
\code{measure}, (raw alpha, norm alpha, raw rho, etc.),
\code{q} (parameter of conservatism), 
\code{type_level} (), 
\code{type_name} (label attributed to type), 
\code{partition_level} (level of diversity, \emph{i.e.} subcommunity), 
\code{partition_name} (label attributed to partition), and 
\code{diversity}}

\item{\code{results}}{\code{matrix} of mode \code{numeric}; contains values 
calculated from diversity-term values output from \code{raw_alpha()}, 
\code{norm_alpha()}, \code{raw_rho()}, \code{norm_rho()}, or 
\code{raw_gamma()}}

\item{\code{type_abundance}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains proportional abundance of \emph{types} in the subcommunity 
as a fraction of the metacommunity as a whole (in the phylogenetic case, 
this corresponds to the proportional abundance of historic species, which
is calculated from the proportional abundance of present day species)}

\item{\code{ordinariness}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains ordinariness of types}

\item{\code{subcommunity_weights}}{\code{vector} of mode \code{numeric}; contains
subcommunity weights}

\item{\code{type_weights}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains weight of types within a subcommunity}
}}

\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2014. How to partition diversity. 
arXiv 1404.6520:1–9.
}
