% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-components.R
\name{norm_rho}
\alias{norm_rho}
\title{Normalised rho (low level diversity component)}
\usage{
norm_rho(meta)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}
}
\value{
Returns an object of class \code{powermean}.
}
\description{
Calculates the low-level diversity component necessary for calculating
normalised rho diversity.
}
\details{
Values generated from \code{norm_rho()} may be input into \code{subdiv()} and
\code{metadiv()} to calculate normalised subcommunity/metacommunity rho
diversity.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate normalised rho component
norm_rho(meta)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2014. How to partition diversity. 
arXiv 1404.6520:1–9.
}
