% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfp_utils.R
\name{dfp_date_to_list}
\alias{dfp_date_to_list}
\title{Format a datetime for DFP}
\usage{
dfp_date_to_list(this_date, daytime = c("beginning", "end"),
  timeZoneId = Sys.timezone(), ensure_today_works = TRUE)
}
\arguments{
\item{this_date}{Date; formatted as Date, POSIXct, or POSIXlt}

\item{daytime}{character; either "beginning" or "end" so that the function 
knows which hours to set if needed}

\item{timeZoneId}{character; a string indicating the timezone that should be used. 
The timezone ID must be in Time_Zone database}

\item{ensure_today_works}{logical; an indicator that will automatically offset 
the current time by 1 hour so that forecasts will actually work. If you try to 
forecast from a timestamp of now, then by the time you submit it to the ForecastService 
it will already be too late to be in the future.}
}
\value{
a \code{list} formatted to the spec required for StartDateTime or EndDateTime
}
\description{
Take a datetime representation in R and convert it to the list required by 
DFP to indicate a datetime
}
\examples{
dfp_date_to_list(Sys.Date()+1)
}
