% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContentService.R
\name{dfp_getContentByStatement}
\alias{dfp_getContentByStatement}
\title{ContentService}
\usage{
dfp_getContentByStatement(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getContentByStatementResponse
}
\description{
Service for retrieving Content.
Content entities can be targeted in
video LineItems.
You can query for content that belongs to a particular
category or has assigned metadata. Categories and metadata for Content are
stored in DFP as CustomCriteria.
For example, to find all Content that
is "genre=comedy", you would:
\itemize{
  \item{Retrieve the custom targeting key
corresponding to "genre" using
CustomTargetingService#getCustomTargetingKeysByStatement}
  \item{Using the
CustomTargetingService#getCustomTargetingValuesByStatement method and a
filter like "WHERE customTargetingKeyId = :genreKeyId and name = 'comedy'",
retrieve the ID for the "comedy" custom targeting value.}
  \item{Call
#getContentByStatementAndCustomTargetingValue with a filter like "WHERE
status = 'ACTIVE'" and the ID of the custom targeting value from step 2.}
}
}
\details{
getContentByStatement

Gets a ContentPage of Content objects that satisfy the given \{@link Statement query\}. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{status}
  \item{name}
  \item{lastModifiedDateTime}
  \item{lastDaiIngestDateTime}
  \item{daiIngestStatus}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getContentByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ContentService#getContentByStatement}{Google Documentation for getContentByStatement}
}
