% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomTargetingService.R
\name{dfp_createCustomTargetingKeys}
\alias{dfp_createCustomTargetingKeys}
\title{CustomTargetingService}
\usage{
dfp_createCustomTargetingKeys(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCustomTargetingKeysResponse
}
\description{
Provides operations for creating, updating and retrieving
CustomTargetingKey and CustomTargetingValue objects.
}
\details{
createCustomTargetingKeys

Creates new CustomTargetingKey objects. The following fields are required: 
\itemize{
  \item{CustomTargetingKey name}
  \item{CustomTargetingKey type}
}
}
\examples{
\dontrun{
request_data <- list(keys=list(name="Test1", 
                               displayName="TestKey1", 
                               type='FREEFORM'))
result <- dfp_createCustomTargetingKeys(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/CustomTargetingService#createCustomTargetingKeys}{Google Documentation for createCustomTargetingKeys}
}
