% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivityService.R
\name{dfp_createActivities}
\alias{dfp_createActivities}
\title{ActivityService}
\usage{
dfp_createActivities(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createActivitiesResponse
}
\description{
Provides methods for creating, updating and retrieving Activity objects.
}
\details{
An activity group contains Activity objects. Activities have a
many-to-one relationship with activity groups, meaning each activity can
belong to only one activity group, but activity groups can have multiple
activities. An activity group can be used to manage the activities it
contains.

createActivities

Creates a new Activity objects.
}
\examples{
\dontrun{
 res <- dfp_createActivities(request_data)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ActivityService#createActivities}{Google Documentation for createActivities}
}
