% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mrdi.R
\name{summary.mrdi}
\alias{summary.mrdi}
\title{Summarize the Multiple Imputation of Multivariate Regression Discontinuity Estimation}
\usage{
\method{summary}{mrdi}(object, level = 0.95, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"mrdi"}, usually a result of a call to 
\code{\link{mrd_impute}} with \code{"front"} method.}

\item{level}{Numerical value between 0 and 1. Confidence level for confidence intervals.}

\item{digits}{Number of digits to display.}

\item{...}{Additional arguments.}
}
\value{
\code{summary.mrdi} returns a list which has the following components:
\item{coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the complete model.}
\item{ht_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the heterogeneous treatment model.}
\item{t_coefficients}{A matrix containing estimates and confidence intervals (if applicable) 
for the treatment only model.}
}
\description{
\code{summary.mrdi} is a \code{summary} method for class \code{"mrdi"}
}
