% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_ik09.R
\name{bw_ik09}
\alias{bw_ik09}
\title{Imbens-Kalyanaraman 2009 Optimal Bandwidth Calculation}
\usage{
bw_ik09(X, Y, cutpoint = NULL, verbose = FALSE, kernel = "triangular")
}
\arguments{
\item{X}{A numerical vector which is the running variable.}

\item{Y}{A numerical vector which is the outcome variable.}

\item{cutpoint}{The cutpoint.}

\item{verbose}{Logical flag indicating whether to print more information to the terminal. 
Default is \code{FALSE}.}

\item{kernel}{String indicating which kernel to use. Options are \code{"triangular"} 
(default and recommended), \code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, and \code{"cosine"}.}
}
\value{
The optimal bandwidth.
}
\description{
\code{bw_ik09} calculates the Imbens-Kalyanaraman (2009) optimal bandwidth
for local linear regression in regression discontinuity designs.
It is based on the \code{\link[rdd]{IKbandwidth}} function in the \pkg{rdd} package. 
This is an internal function and is typically not directly invoked by the user. 
It can be accessed using the triple colon, as in rddapp:::bw_ik09().
}
\references{
Imbens, G., Kalyanaraman, K. (2009). 
  Optimal bandwidth choice for the regression discontinuity estimator 
  (Working Paper No. 14726). National Bureau of Economic Research.
  \url{http://www.nber.org/papers/w14726}.
}
