% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dc_oai_getrecord.R
\name{dc_oai_getrecord}
\alias{dc_oai_getrecord}
\title{Retrieve an individual record from the DataCite repository}
\usage{
dc_oai_getrecord(id)
}
\arguments{
\item{id}{DataCite identifier, e.g., "oai:oai.datacite.org:6718729".
If left blank, get all metadataformats}
}
\description{
Retrieve an individual record from the DataCite repository
}
\examples{
\dontrun{
# you can pass in just the numeric part of the ID
dc_oai_getrecord(56225)
dc_oai_getrecord(c(56225, 6667400))

# Or, the entire thing
dc_oai_getrecord("oai:oai.datacite.org:56225")

# Or, mixed
dc_oai_getrecord(c("56225", "oai:oai.datacite.org:6667400"))

today <- format(Sys.Date(), "\%Y-\%m-\%d")
temp <- dc_oai_listidentifiers(from = today)
dc_oai_getrecord(temp$identifier[1:2])
}
}
