% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corridor.R
\name{delineate_corridor}
\alias{delineate_corridor}
\title{Delineate a river corridor on a spatial network.}
\usage{
delineate_corridor(
  network,
  river,
  corridor_init = 1000,
  max_width = 3000,
  max_iterations = 10,
  capping_method = "shortest-path"
)
}
\arguments{
\item{network}{The spatial network to be used for the delineation}

\item{river}{A (MULTI)LINESTRING simple feature geometry representing the
river centerline}

\item{corridor_init}{How to estimate the initial guess of the river corridor.
It can take the following values:
\itemize{
\item numeric or integer: use a buffer region of the given size (in meters)
around the river centerline
\item An \code{\link[sf:sf]{sf::sf}} or \code{\link[sf:sfc]{sf::sfc}} object: use the given input geometry
}}

\item{max_width}{(Approximate) maximum width of the corridor. The spatial
network is trimmed by a buffer region of this size around the river}

\item{max_iterations}{Maximum number of iterations employed to refine the
corridor edges (see \code{\link[=corridor_edge]{corridor_edge()}}).}

\item{capping_method}{The method employed to connect the corridor edge end
points (i.e. to "cap" the corridor). See \code{\link[=cap_corridor]{cap_corridor()}} for
the available methods}
}
\value{
A simple feature geometry representing the river corridor
}
\description{
The corridor edges on the two river banks are drawn on the provided spatial
network starting from an initial guess of the corridor (based e.g. on the
river valley).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
network <- rbind(bucharest_osm$streets, bucharest_osm$railways) |>
  as_network()
delineate_corridor(network, bucharest_osm$river_centerline)
\dontshow{\}) # examplesIf}
}
