% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{ordering.HPDataFrame}
\alias{ordering.HPDataFrame}
\title{HEALPix ordering scheme from a HPDataFrame}
\usage{
\method{ordering}{HPDataFrame}(x, new.ordering, ...)
}
\arguments{
\item{x}{a \code{\link{HPDataFrame}}.}

\item{new.ordering}{Specifies the new ordering ("ring" or "nest")
if a change of ordering scheme is desired.}

\item{...}{Unused arguments.}
}
\value{
The name of the HEALPix ordering scheme that is used in the
HPDataFrame x, or a new HPDataFrame
with the desired new.ordering
}
\description{
This function returns the HEALPix ordering scheme from a HPDataFrame.
The ordering scheme is either "ring" or "nested". If a new ordering
is specified, using e.g. \code{new.ordering = "ring"}, the
ordering scheme of the HPDataFrame will be converted.
}
\examples{

df <- HPDataFrame(I = rep(0,12), nside = 1, ordering = "nested")
ordering(df)
df1 <- ordering(df, new.ordering = "ring")
ordering(df1)

}
