% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileCI.r
\name{quantileCI}
\alias{quantileCI}
\title{Quantiles and confidence intervals}
\usage{
quantileCI(
  x,
  tau = 0.5,
  level = 0.95,
  method = "binomial",
  type = 3,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{The vector of observations.
Can be an ordered factor as long as \code{type}
is 1 or 3.}

\item{tau}{The quantile to use,
e.g. 0.5 for median, 0.25 for 25th percentile.}

\item{level}{The confidence interval to use, 
e.g. 0.95 for 95 percent confidence interval.}

\item{method}{If \code{"binomial"}, uses the binomial distribution 
the confidence limits.
If \code{"normal"}, uses the normal approximation to the
binomial distribution.}

\item{type}{The \code{type} value passed to the \code{quantile} function.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments, ignored.}
}
\value{
A data frame of summary statistics, quantile estimate, 
              and confidence limits.
}
\description{
Calculates an estimate for a quantile 
              and confidence intervals for
              a vector of discrete or continuous
              values
}
\details{
Conover recommends the \code{"binomial"} method for sample
              sizes less than or equal to 20.
              With the current implementation, 
              this method can be used also for
              larger sample sizes.
}
\examples{
### From Conover, Practical Nonparametric Statistics, 3rd
Hours = c(46.9, 47.2, 49.1, 56.5, 56.8, 59.2, 59.9, 63.2,
          63.3, 63.4, 63.7, 64.1, 67.1, 67.7, 73.3, 78.5)
quantileCI(Hours)

### Example with ordered factor
set.seed(12345)
Pool = factor(c("smallest", "small", "medium", "large", "largest"),
             ordered=TRUE, 
             levels=c("smallest", "small", "medium", "large", "largest"))
Sample = sample(Pool, 24, replace=TRUE)
quantileCI(Sample)
                 
}
\references{
\url{http://rcompanion.org/handbook/E_04.html}

              Conover, W.J., Practical Nonparametric Statistics, 3rd.
}
\seealso{
\code{\link{groupwisePercentile}}, 
              \code{\link{groupwiseMedian}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{confidence interval}
\concept{percentile}
\concept{quantile}
