% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getClimateDataRaw}
\alias{getClimateDataRaw}
\title{Get parsed CSV data from Environment Canada}
\usage{
getClimateDataRaw(stationID, timeframe = c("monthly", "daily", "hourly"),
  Year = NA, Month = NA,
  endpoint = "http://climate.weather.gc.ca/climate_data/bulk_data_e.html",
  ...)
}
\arguments{
\item{stationID}{A stationID (you could find this using \link{getClimateSites})}

\item{timeframe}{One of "montly" "daily" or "hourly"}

\item{Year}{The year for which to fetch the data}

\item{Month}{The month for which to fetch the data}

\item{endpoint}{The url from which to fetch data (in case this changes in the future)}

\item{...}{further arguments passed on to the downloading function}
}
\value{
A data.frame of results
}
\description{
This function just donloads a .csv file from the bulk data service from
Environment Canda. It follows as closely as possible the EC specifications,
and does not modify the result except to remove the header information. To
apply this function over multiple months/stations/years/months, use \link{getClimateData}.
}
\examples{
# don't test because fetching of file slows down testing
\donttest{
getClimateDataRaw(27141, timeframe="monthly")
}
}
\references{
\url{http://climate.weather.gc.ca/historical_data/search_historic_data_e.html}
\url{ftp://client_climate@ftp.tor.ec.gc.ca/Pub/Get_More_Data_Plus_de_donnees/Readme.txt}
}

