% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_aml.R
\name{aml_to_json}
\alias{aml_to_json}
\title{Convert AML to JSON}
\usage{
aml_to_json(aml, pretty = FALSE, indent = 4)
}
\arguments{
\item{aml}{a string, file, connection, URL, or  Google Drive ID created by
\link[googledrive:as_id]{googledrive::as_id} from which to read ArchieML. Inputs of length > 1,
with line breaks, or non-existent filenames will always be treated as raw
ArchieML.  To read multiple ArchieML inputs use a function such as \link{lapply}.}

\item{pretty}{prettify JSON output?}

\item{indent}{if prettifying, what indent level? Passed to
\link[jsonlite]{prettify}.}
}
\value{
A length-1 character vector of class "json"
}
\description{
This imports data from  New York Times' ArchieML format as a JSON sting.
Text is parsed to JSON using
\href{https://github.com/newsdev/archieml-js}{archieml-js}.
}
\examples{
aml_to_json(aml = "key: value")
aml_to_json("http://archieml.org/test/1.0/arrays.1.aml")

\donttest{\dontrun{
# See source at:
# https://drive.google.com/open?id=1oYHXxvzscBBSBhd6xg5ckUEZo3tLytk9zY0VV_Y7SGs
library(googledrive)
aml_to_json(as_id("1oYHXxvzscBBSBhd6xg5ckUEZo3tLytk9zY0VV_Y7SGs"),
  pretty = TRUE)
}}
}
\references{
\url{http://archieml.org/}
}
\seealso{
\link{from_aml}
}
