/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;
import org.openscience.cdk.math.qm.Orbitals;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ClosedShellJob {
    private Orbitals orbitals;
    private Vector E;
    private static ILoggingTool log = LoggingToolFactory.createLoggingTool(ClosedShellJob.class);
    private int iterations = 0;

    public ClosedShellJob(Orbitals orbitals) {
        this.orbitals = orbitals;
    }

    public Vector getEnergies() {
        return this.E.duplicate();
    }

    private void sort(Matrix matrixC, Vector E) {
        boolean changed;
        do {
            changed = false;
            for (int i = 1; i < E.size; ++i) {
                if (!(E.vector[i - 1] > E.vector[i])) continue;
                double value = E.vector[i];
                E.vector[i] = E.vector[i - 1];
                E.vector[i - 1] = value;
                for (int j = 0; j < matrixC.rows; ++j) {
                    value = matrixC.matrix[j][i];
                    matrixC.matrix[j][i] = matrixC.matrix[j][i - 1];
                    matrixC.matrix[j][i - 1] = value;
                }
                changed = true;
            }
        } while (changed);
    }

    private Matrix calculateS(IBasis basis) {
        int size = basis.getSize();
        Matrix matrixS = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixS.matrix[i][j] = basis.calcS(i, j);
            }
        }
        return matrixS;
    }

    private Matrix calculateT(IBasis basis) {
        int size = basis.getSize();
        Matrix matrixJ = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixJ.matrix[i][j] = basis.calcJ(j, i) / 2.0;
            }
        }
        return matrixJ;
    }

    private Matrix calculateV(IBasis basis) {
        int size = basis.getSize();
        Matrix matrixV = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixV.matrix[i][j] = basis.calcV(i, j);
            }
        }
        return matrixV;
    }

    private double[][][][] calculateI(IBasis basis) {
        int size = basis.getSize();
        double[][][][] result = new double[size][][][];
        for (int i = 0; i < size; ++i) {
            result[i] = new double[i + 1][][];
            for (int j = 0; j <= i; ++j) {
                result[i][j] = new double[size][];
                for (int k = 0; k < size; ++k) {
                    result[i][j][k] = new double[k + 1];
                    for (int l = 0; l <= k; ++l) {
                        result[i][j][k][l] = basis.calcI(i, j, k, l);
                    }
                }
            }
        }
        return result;
    }

    private Matrix calculateD(IBasis basis, Matrix matrixC, int count_electrons) {
        int size = basis.getSize();
        int orbitals = matrixC.getColumns();
        int occ = count_electrons / 2;
        int locc = count_electrons % 2;
        Matrix matrixD = new Matrix(size, size);
        log.debug("D:occ=" + occ + " locc=" + locc);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k;
                matrixD.matrix[i][j] = 0.0;
                for (k = 0; k < orbitals && k < occ; ++k) {
                    double[] dArray = matrixD.matrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + 2.0 * matrixC.matrix[i][k] * matrixC.matrix[j][k];
                }
                if (locc != 1 || k + 1 >= orbitals) continue;
                double[] dArray = matrixD.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + matrixC.matrix[i][k + 1] * matrixC.matrix[j][k + 1];
            }
        }
        return matrixD;
    }

    private Matrix calculateJ(IBasis basis, double[][][][] I, Matrix matrixD) {
        int size = basis.getSize();
        Matrix matrixJ = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            int j = 0;
            while (j < size) {
                matrixJ.matrix[i][j] = 0.0;
                for (int k = 0; k < size; ++k) {
                    for (int l = 0; l < size; ++l) {
                        if (i >= j) {
                            if (k >= l) {
                                double[] dArray = matrixJ.matrix[i];
                                int n = j;
                                dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[i][j][k][l];
                                continue;
                            }
                            double[] dArray = matrixJ.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[i][j][l][k];
                            continue;
                        }
                        if (k >= l) {
                            double[] dArray = matrixJ.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[j][i][k][l];
                            continue;
                        }
                        double[] dArray = matrixJ.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[j][i][l][k];
                    }
                }
                double[] dArray = matrixJ.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] * 2.0;
            }
        }
        return matrixJ;
    }

    private Matrix calculateK(IBasis basis, double[][][][] I, Matrix matrixD) {
        int size = basis.getSize();
        Matrix matrixK = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrixK.matrix[i][j] = 0.0;
                for (int k = 0; k < size; ++k) {
                    for (int l = 0; l < size; ++l) {
                        if (i >= j) {
                            if (k >= l) {
                                double[] dArray = matrixK.matrix[i];
                                int n = j;
                                dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[i][j][k][l];
                                continue;
                            }
                            double[] dArray = matrixK.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[i][j][l][k];
                            continue;
                        }
                        if (k >= l) {
                            double[] dArray = matrixK.matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[j][i][k][l];
                            continue;
                        }
                        double[] dArray = matrixK.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + matrixD.matrix[k][l] * I[j][i][l][k];
                    }
                }
            }
        }
        return matrixK;
    }

    private double contraction(Matrix matrixA, Matrix matrixB) {
        double result = 0.0;
        for (int i = 0; i < matrixA.rows; ++i) {
            for (int j = 0; j < matrixA.columns; ++j) {
                result += matrixA.matrix[i][j] * matrixB.matrix[i][j];
            }
        }
        return result;
    }

    public Orbitals calculate() {
        long time = System.currentTimeMillis();
        IBasis basis = this.orbitals.getBasis();
        int countElectrons = this.orbitals.getCountElectrons();
        Matrix matrixC = this.orbitals.getCoefficients().duplicate();
        Matrix matricS = this.calculateS(basis);
        log.debug("S = \n" + matricS + "\n");
        log.debug("C = \n" + matrixC + "\n");
        matrixC = matrixC.orthonormalize(matricS);
        log.debug("C' = \n" + matrixC + "\n");
        log.debug("C't * S * C' = \n" + matricS.similar(matrixC) + "\n");
        Matrix matrixT = this.calculateT(basis);
        log.debug("T = \n" + matrixT + "\n");
        Matrix matrixV = this.calculateV(basis);
        log.debug("V = \n" + matrixV + "\n");
        Matrix HAO = matrixT.add(matrixV);
        log.debug("HAO = \n" + HAO + "\n");
        Matrix matrixH = HAO.similar(matrixC);
        log.debug("H = C't * HAO * C' = \n" + matrixH.similar(matrixC) + "\n");
        Matrix matrixU = matrixH.diagonalize(50);
        this.E = matrixH.similar(matrixU).getVectorFromDiagonal();
        matrixC = matrixC.mul(matrixU);
        this.sort(matrixC, this.E);
        log.debug("C(neu) = \n" + matrixC + "\n");
        log.debug("E = \n" + this.E + "\n");
        for (int j = 0; j < this.E.size; ++j) {
            log.debug("E(" + (j + 1) + ".Orbital)=" + this.E.vector[j] * 27.211 + " eV");
        }
        time = System.currentTimeMillis() - time;
        log.debug("Time = " + time + " ms");
        time = System.currentTimeMillis();
        double[][][][] matrixI = this.iterations > 0 ? this.calculateI(basis) : (double[][][][])null;
        for (int i = 0; i < this.iterations; ++i) {
            log.debug(i + 1 + ".Durchlauf\n");
            time = System.currentTimeMillis();
            log.debug("C't * S * C' = \n" + matricS.similar(matrixC) + "\n");
            log.debug("count of electrons = " + countElectrons + "\n");
            Matrix matrixD = this.calculateD(basis, matrixC, countElectrons);
            log.debug("D = \n" + matrixD + "\n");
            log.debug("2*contraction(D*S) = " + this.contraction(matrixD, matricS) * 2.0 + "\n");
            Matrix matrixJ = this.calculateJ(basis, matrixI, matrixD);
            log.debug("J = \n" + matrixJ + "\n");
            Matrix matrixK = this.calculateK(basis, matrixI, matrixD);
            log.debug("K = \n" + matrixK + "\n");
            Matrix matrixF = HAO.add(matrixJ).sub(matrixK);
            log.debug("F = H+J-K = \n" + matrixF + "\n");
            matrixH = matrixF.similar(matrixC);
            log.debug("H = C't * F * C' = \n" + matrixH + "\n");
            matrixU = matrixH.diagonalize(50);
            this.E = matrixH.similar(matrixU).getVectorFromDiagonal();
            matrixC = matrixC.mul(matrixU);
            this.sort(matrixC, this.E);
            log.debug("C(neu) = \n" + matrixC + "\n");
            log.debug("E = \n" + this.E + "\n");
            for (int j = 0; j < this.E.size; ++j) {
                log.debug("E(" + (j + 1) + ".Orbital)=" + this.E.vector[j] * 27.211 + " eV");
            }
            double energy = this.contraction(matrixD, HAO.add(matrixF));
            log.debug("Gesamtenergie = " + energy + " (" + energy * 27.211 + " eV)\n");
            time = System.currentTimeMillis() - time;
            log.debug("Time = " + time + " ms");
            System.gc();
        }
        return new Orbitals(basis, matrixC);
    }
}

