/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AliphaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AliphaticSymbolAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticOrSingleQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AromaticSymbolAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.AtomicNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ChiralityAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ExplicitConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.FormalChargeAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.HybridizationNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.HydrogenAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ImplicitHCountAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorBond;
import org.openscience.cdk.isomorphism.matchers.smarts.MassAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.NonCHHeavyAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.OrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.PeriodicGroupNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.ReactionRoleQueryAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RecursiveSmartsAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RingBond;
import org.openscience.cdk.isomorphism.matchers.smarts.RingIdentifierAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.RingMembershipAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SmallestRingAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.StereoBond;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalHCountAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalRingConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalValencyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAliphatic;
import org.openscience.cdk.smiles.smarts.parser.ASTAnyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAromatic;
import org.openscience.cdk.smiles.smarts.parser.ASTAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTAtomicMass;
import org.openscience.cdk.smiles.smarts.parser.ASTAtomicNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTCharge;
import org.openscience.cdk.smiles.smarts.parser.ASTChirality;
import org.openscience.cdk.smiles.smarts.parser.ASTElement;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitHighAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTExplicitHighAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTGroup;
import org.openscience.cdk.smiles.smarts.parser.ASTHybrdizationNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHCount;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHighAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTImplicitHighAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTLowAndBond;
import org.openscience.cdk.smiles.smarts.parser.ASTLowAndExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTNonCHHeavyAtom;
import org.openscience.cdk.smiles.smarts.parser.ASTNotBond;
import org.openscience.cdk.smiles.smarts.parser.ASTNotExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTOrBond;
import org.openscience.cdk.smiles.smarts.parser.ASTOrExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTPeriodicGroupNumber;
import org.openscience.cdk.smiles.smarts.parser.ASTReaction;
import org.openscience.cdk.smiles.smarts.parser.ASTRecursiveSmartsExpression;
import org.openscience.cdk.smiles.smarts.parser.ASTRingConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTRingIdentifier;
import org.openscience.cdk.smiles.smarts.parser.ASTRingMembership;
import org.openscience.cdk.smiles.smarts.parser.ASTSimpleBond;
import org.openscience.cdk.smiles.smarts.parser.ASTSmallestRingSize;
import org.openscience.cdk.smiles.smarts.parser.ASTSmarts;
import org.openscience.cdk.smiles.smarts.parser.ASTStart;
import org.openscience.cdk.smiles.smarts.parser.ASTTotalConnectivity;
import org.openscience.cdk.smiles.smarts.parser.ASTTotalHCount;
import org.openscience.cdk.smiles.smarts.parser.ASTValence;
import org.openscience.cdk.smiles.smarts.parser.Node;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParserVisitor;
import org.openscience.cdk.smiles.smarts.parser.SimpleNode;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SmartsQueryVisitor
implements SMARTSParserVisitor {
    private RingIdentifierAtom[] ringAtoms;
    private IQueryAtomContainer query;
    private final IChemObjectBuilder builder;
    private Map<IAtom, List<IAtom>> neighbors = new HashMap<IAtom, List<IAtom>>();
    private BitSet tetrahedral = new BitSet();
    private List<IBond> stereoBonds = new ArrayList<IBond>();
    private List<IBond> doubleBonds = new ArrayList<IBond>();
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmartsQueryVisitor.class);

    public SmartsQueryVisitor(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @Override
    public Object visit(ASTRingIdentifier node, Object data) {
        IQueryAtom atom = (IQueryAtom)data;
        RingIdentifierAtom ringIdAtom = new RingIdentifierAtom(this.builder);
        ringIdAtom.setAtom(atom);
        IQueryBond bond = node.jjtGetNumChildren() == 0 ? null : (IQueryBond)node.jjtGetChild(0).jjtAccept(this, data);
        ringIdAtom.setRingBond(bond);
        return ringIdAtom;
    }

    @Override
    public Object visit(ASTAtom node, Object data) {
        IQueryAtom atom = (IQueryAtom)node.jjtGetChild(0).jjtAccept(this, data);
        int i = 1;
        if (i < node.jjtGetNumChildren()) {
            throw new IllegalStateException();
        }
        return atom;
    }

    private void handleRingClosure(IQueryAtom atom, ASTRingIdentifier ringIdentifier) {
        RingIdentifierAtom ringIdAtom = (RingIdentifierAtom)ringIdentifier.jjtAccept(this, atom);
        int ringId = ringIdentifier.getRingId();
        if (ringId >= this.ringAtoms.length) {
            this.ringAtoms = Arrays.copyOf(this.ringAtoms, 100);
        }
        if (this.ringAtoms[ringId] == null) {
            this.ringAtoms[ringId] = ringIdAtom;
            if (this.neighbors.containsKey(atom)) {
                this.neighbors.get(atom).add(ringIdAtom);
            }
        } else {
            IQueryBond ringBond = this.ringAtoms[ringId].getRingBond() == null ? (ringIdAtom.getRingBond() == null ? (atom instanceof AromaticSymbolAtom && this.ringAtoms[ringId].getAtom() instanceof AromaticSymbolAtom ? new AromaticQueryBond(this.builder) : new RingBond(this.builder)) : ringIdAtom.getRingBond()) : this.ringAtoms[ringId].getRingBond();
            ringBond.setAtoms(new IAtom[]{this.ringAtoms[ringId].getAtom(), atom});
            this.query.addBond(ringBond);
            if (this.neighbors.containsKey(this.ringAtoms[ringId].getAtom())) {
                List<IAtom> localNeighbors = this.neighbors.get(this.ringAtoms[ringId].getAtom());
                localNeighbors.set(localNeighbors.indexOf(this.ringAtoms[ringId]), atom);
            }
            if (this.neighbors.containsKey(atom)) {
                this.neighbors.get(atom).add(this.ringAtoms[ringId].getAtom());
            }
            this.ringAtoms[ringId] = null;
        }
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    @Override
    public Object visit(ASTReaction node, Object data) {
        QueryAtomContainer query2 = new QueryAtomContainer(this.builder);
        for (int grpIdx = 0; grpIdx < node.jjtGetNumChildren(); ++grpIdx) {
            int rollback = query2.getAtomCount();
            ASTGroup group = (ASTGroup)node.jjtGetChild(grpIdx);
            group.jjtAccept(this, query2);
            if (group.getRole() == 7) continue;
            ReactionRoleQueryAtom roleQueryAtom = null;
            ReactionRole role = null;
            switch (group.getRole()) {
                case 1: {
                    roleQueryAtom = ReactionRoleQueryAtom.RoleReactant;
                    role = ReactionRole.Reactant;
                    break;
                }
                case 2: {
                    roleQueryAtom = ReactionRoleQueryAtom.RoleAgent;
                    role = ReactionRole.Agent;
                    break;
                }
                case 4: {
                    roleQueryAtom = ReactionRoleQueryAtom.RoleProduct;
                    role = ReactionRole.Product;
                }
            }
            if (roleQueryAtom == null) continue;
            while (rollback < query2.getAtomCount()) {
                IAtom org = query2.getAtom(rollback);
                SMARTSAtom rep = LogicalOperatorAtom.and(roleQueryAtom, (IQueryAtom)org);
                rep.setProperty("cdk:AtomAtomMapping", org.getProperty("cdk:AtomAtomMapping"));
                rep.setProperty("cdk:ReactionRole", (Object)role);
                AtomContainerManipulator.replaceAtomByAtom(query2, org, rep);
                ++rollback;
            }
        }
        return query2;
    }

    @Override
    public Object visit(ASTGroup node, Object data) {
        IAtomContainer fullQuery = (IAtomContainer)data;
        if (fullQuery == null) {
            fullQuery = new QueryAtomContainer(this.builder);
        }
        int[] components = fullQuery.getProperty("COMPONENT.GROUPING") != null ? fullQuery.getProperty("COMPONENT.GROUPING", int[].class) : new int[]{};
        int maxId = 0;
        if (components.length > 0) {
            for (int id : components) {
                if (id <= maxId) continue;
                maxId = id;
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTSmarts smarts = (ASTSmarts)node.jjtGetChild(i);
            this.ringAtoms = new RingIdentifierAtom[10];
            this.query = new QueryAtomContainer(this.builder);
            smarts.jjtAccept(this, null);
            if (components.length > 0 || smarts.componentId() > 0) {
                components = Arrays.copyOf(components, 1 + fullQuery.getAtomCount() + this.query.getAtomCount());
                int id = smarts.componentId();
                Arrays.fill(components, fullQuery.getAtomCount(), components.length, id);
                if (id > maxId) {
                    maxId = id;
                }
            }
            fullQuery.add(this.query);
        }
        if (maxId > 0) {
            components[components.length - 1] = maxId;
            fullQuery.setProperty("COMPONENT.GROUPING", components);
        }
        for (IAtom atom : this.neighbors.keySet()) {
            List<IAtom> localNeighbors = this.neighbors.get(atom);
            if (localNeighbors.size() == 4) {
                fullQuery.addStereoElement(new TetrahedralChirality(atom, localNeighbors.toArray(new IAtom[4]), ITetrahedralChirality.Stereo.CLOCKWISE));
                continue;
            }
            if (localNeighbors.size() != 5) continue;
            localNeighbors.remove(atom);
            fullQuery.addStereoElement(new TetrahedralChirality(atom, localNeighbors.toArray(new IAtom[4]), ITetrahedralChirality.Stereo.CLOCKWISE));
        }
        for (IBond bond : this.doubleBonds) {
            IAtom left = bond.getBegin();
            IAtom right = bond.getEnd();
            StereoBond leftBond = this.findStereoBond(left);
            StereoBond rightBond = this.findStereoBond(right);
            if (leftBond == null || rightBond == null) continue;
            IDoubleBondStereochemistry.Conformation conformation = leftBond.direction(left) == rightBond.direction(right) ? IDoubleBondStereochemistry.Conformation.TOGETHER : IDoubleBondStereochemistry.Conformation.OPPOSITE;
            fullQuery.addStereoElement(new DoubleBondStereochemistry(bond, new IBond[]{leftBond, rightBond}, conformation));
        }
        return fullQuery;
    }

    private StereoBond findStereoBond(IAtom atom) {
        for (IBond bond : this.stereoBonds) {
            if (!bond.contains(atom)) continue;
            return (StereoBond)bond;
        }
        return null;
    }

    @Override
    public Object visit(ASTSmarts node, Object data) {
        SMARTSAtom atom = null;
        SMARTSBond bond = null;
        ASTAtom first = (ASTAtom)node.jjtGetChild(0);
        atom = (SMARTSAtom)first.jjtAccept(this, null);
        if (data != null) {
            bond = (SMARTSBond)((Object[])data)[1];
            SMARTSAtom prev = (SMARTSAtom)((Object[])data)[0];
            if (bond == null) {
                bond = new AromaticOrSingleQueryBond(this.builder);
                bond.setAtoms(new IAtom[]{prev, atom});
            } else {
                bond.setAtoms(new IAtom[]{prev, atom});
            }
            if (this.neighbors.containsKey(prev)) {
                this.neighbors.get(prev).add(atom);
            }
            this.query.addBond(bond);
            bond = null;
        }
        this.query.addAtom(atom);
        if (this.tetrahedral.get(this.query.getAtomCount() - 1)) {
            ArrayList<IAtom> localNeighbors = new ArrayList<IAtom>(this.query.getConnectedAtomsList(atom));
            localNeighbors.add(atom);
            this.neighbors.put(atom, localNeighbors);
        }
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child instanceof ASTLowAndBond) {
                bond = (SMARTSBond)child.jjtAccept(this, data);
                continue;
            }
            if (child instanceof ASTAtom) {
                SMARTSAtom newAtom = (SMARTSAtom)child.jjtAccept(this, null);
                if (bond == null) {
                    bond = new AromaticOrSingleQueryBond(this.builder);
                }
                bond.setAtoms(new IAtom[]{atom, newAtom});
                this.query.addBond(bond);
                this.query.addAtom(newAtom);
                if (this.neighbors.containsKey(atom)) {
                    this.neighbors.get(atom).add(newAtom);
                }
                if (this.tetrahedral.get(this.query.getAtomCount() - 1)) {
                    ArrayList<IAtom> localNeighbors = new ArrayList<IAtom>(this.query.getConnectedAtomsList(newAtom));
                    localNeighbors.add(newAtom);
                    this.neighbors.put(newAtom, localNeighbors);
                }
                atom = newAtom;
                bond = null;
                continue;
            }
            if (child instanceof ASTSmarts) {
                child.jjtAccept(this, new Object[]{atom, bond});
                bond = null;
                continue;
            }
            if (child instanceof ASTRingIdentifier) {
                this.handleRingClosure(atom, (ASTRingIdentifier)child);
                continue;
            }
            throw new IllegalStateException("Unhandled node type: " + child.getClass());
        }
        return this.query;
    }

    @Override
    public Object visit(ASTNotBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.getType() == 5) {
            LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
            bond.setOperator("not");
            bond.setLeft((IQueryBond)left);
            return bond;
        }
        return left;
    }

    @Override
    public Object visit(ASTImplicitHighAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    @Override
    public Object visit(ASTLowAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    @Override
    public Object visit(ASTOrBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("or");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    @Override
    public Object visit(ASTExplicitHighAndBond node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        LogicalOperatorBond bond = new LogicalOperatorBond(this.builder);
        bond.setOperator("and");
        bond.setLeft((IQueryBond)left);
        IQueryBond right = (IQueryBond)node.jjtGetChild(1).jjtAccept(this, data);
        bond.setRight(right);
        return bond;
    }

    @Override
    public Object visit(ASTSimpleBond node, Object data) {
        SMARTSBond bond = null;
        switch (node.getBondType()) {
            case 6: {
                bond = new OrderQueryBond(IBond.Order.SINGLE, this.builder);
                break;
            }
            case 11: {
                bond = new OrderQueryBond(IBond.Order.DOUBLE, this.builder);
                this.doubleBonds.add(bond);
                break;
            }
            case 12: {
                bond = new OrderQueryBond(IBond.Order.TRIPLE, this.builder);
                break;
            }
            case 43: {
                bond = new OrderQueryBond(IBond.Order.QUADRUPLE, this.builder);
                break;
            }
            case 14: {
                bond = new AnyOrderQueryBond(this.builder);
                break;
            }
            case 13: {
                bond = new AromaticQueryBond(this.builder);
                break;
            }
            case 15: {
                bond = new RingBond(this.builder);
                break;
            }
            case 7: {
                bond = new StereoBond(this.builder, StereoBond.Direction.UP, false);
                this.stereoBonds.add(bond);
                break;
            }
            case 8: {
                bond = new StereoBond(this.builder, StereoBond.Direction.DOWN, false);
                this.stereoBonds.add(bond);
                break;
            }
            case 9: {
                bond = new StereoBond(this.builder, StereoBond.Direction.UP, true);
                this.stereoBonds.add(bond);
                break;
            }
            case 10: {
                bond = new StereoBond(this.builder, StereoBond.Direction.DOWN, true);
                this.stereoBonds.add(bond);
                break;
            }
            default: {
                logger.error("Un parsed bond: " + node.toString());
            }
        }
        return bond;
    }

    @Override
    public Object visit(ASTRecursiveSmartsExpression node, Object data) {
        SmartsQueryVisitor recursiveVisitor = new SmartsQueryVisitor(this.builder);
        recursiveVisitor.query = new QueryAtomContainer(this.builder);
        recursiveVisitor.ringAtoms = new RingIdentifierAtom[10];
        return new RecursiveSmartsAtom((IQueryAtomContainer)node.jjtGetChild(0).jjtAccept(recursiveVisitor, null));
    }

    public ASTStart getRoot(Node node) {
        if (node instanceof ASTStart) {
            return (ASTStart)node;
        }
        return this.getRoot(node.jjtGetParent());
    }

    @Override
    public Object visit(ASTElement node, Object data) {
        SMARTSAtom atom;
        String symbol = node.getSymbol();
        if ("o".equals(symbol) || "n".equals(symbol) || "c".equals(symbol) || "s".equals(symbol) || "p".equals(symbol) || "as".equals(symbol) || "se".equals(symbol)) {
            String atomSymbol = symbol.substring(0, 1).toUpperCase() + symbol.substring(1);
            atom = new AromaticSymbolAtom(atomSymbol, this.builder);
        } else {
            atom = new AliphaticSymbolAtom(symbol, this.builder);
        }
        return atom;
    }

    @Override
    public Object visit(ASTTotalHCount node, Object data) {
        return new TotalHCountAtom(node.getCount(), this.builder);
    }

    @Override
    public Object visit(ASTImplicitHCount node, Object data) {
        return new ImplicitHCountAtom(node.getCount(), this.builder);
    }

    @Override
    public Object visit(ASTExplicitConnectivity node, Object data) {
        return new ExplicitConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    @Override
    public Object visit(ASTAtomicNumber node, Object data) {
        return new AtomicNumberAtom(node.getNumber(), this.builder);
    }

    @Override
    public Object visit(ASTHybrdizationNumber node, Object data) {
        return new HybridizationNumberAtom(node.getHybridizationNumber(), this.builder);
    }

    @Override
    public Object visit(ASTCharge node, Object data) {
        if (node.isPositive()) {
            return new FormalChargeAtom(node.getCharge(), this.builder);
        }
        return new FormalChargeAtom(0 - node.getCharge(), this.builder);
    }

    @Override
    public Object visit(ASTRingConnectivity node, Object data) {
        return new TotalRingConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    @Override
    public Object visit(ASTPeriodicGroupNumber node, Object data) {
        return new PeriodicGroupNumberAtom(node.getGroupNumber(), this.builder);
    }

    @Override
    public Object visit(ASTTotalConnectivity node, Object data) {
        return new TotalConnectionAtom(node.getNumOfConnection(), this.builder);
    }

    @Override
    public Object visit(ASTValence node, Object data) {
        return new TotalValencyAtom(node.getOrder(), this.builder);
    }

    @Override
    public Object visit(ASTRingMembership node, Object data) {
        return new RingMembershipAtom(node.getNumOfMembership(), this.builder);
    }

    @Override
    public Object visit(ASTSmallestRingSize node, Object data) {
        return new SmallestRingAtom(node.getSize(), this.builder);
    }

    @Override
    public Object visit(ASTAliphatic node, Object data) {
        return new AliphaticAtom(this.builder);
    }

    @Override
    public Object visit(ASTNonCHHeavyAtom node, Object data) {
        return new NonCHHeavyAtom(this.builder);
    }

    @Override
    public Object visit(ASTAromatic node, Object data) {
        return new AromaticAtom(this.builder);
    }

    @Override
    public Object visit(ASTAnyAtom node, Object data) {
        return new AnyAtom(this.builder);
    }

    @Override
    public Object visit(ASTAtomicMass node, Object data) {
        return new MassAtom(node.getMass(), this.builder);
    }

    @Override
    public Object visit(ASTChirality node, Object data) {
        ChiralityAtom atom = new ChiralityAtom(this.builder);
        atom.setClockwise(node.isClockwise());
        atom.setUnspecified(node.isUnspecified());
        this.tetrahedral.set(this.query.getAtomCount());
        return atom;
    }

    @Override
    public Object visit(ASTLowAndExpression node, Object data) {
        IAtom expr = (IAtom)node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() > 1) {
            IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
            expr = LogicalOperatorAtom.and((IQueryAtom)expr, right);
        }
        if (node.getMapIdx() > 0) {
            expr.setProperty("cdk:AtomAtomMapping", node.getMapIdx());
        }
        return expr;
    }

    @Override
    public Object visit(ASTOrExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        return LogicalOperatorAtom.or((IQueryAtom)left, right);
    }

    @Override
    public Object visit(ASTNotExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.getType() == 5) {
            return LogicalOperatorAtom.not((IQueryAtom)left);
        }
        return left;
    }

    @Override
    public Object visit(ASTExplicitHighAndExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        return LogicalOperatorAtom.and((IQueryAtom)left, right);
    }

    @Override
    public Object visit(ASTImplicitHighAndExpression node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 1) {
            return left;
        }
        IQueryAtom right = (IQueryAtom)node.jjtGetChild(1).jjtAccept(this, data);
        return LogicalOperatorAtom.and((IQueryAtom)left, right);
    }

    @Override
    public Object visit(ASTExplicitAtom node, Object data) {
        SMARTSAtom atom = null;
        String symbol = node.getSymbol();
        if ("*".equals(symbol)) {
            atom = new AnyAtom(this.builder);
        } else if ("A".equals(symbol)) {
            atom = new AliphaticAtom(this.builder);
        } else if ("a".equals(symbol)) {
            atom = new AromaticAtom(this.builder);
        } else if ("o".equals(symbol) || "n".equals(symbol) || "c".equals(symbol) || "s".equals(symbol) || "p".equals(symbol) || "as".equals(symbol) || "se".equals(symbol)) {
            String atomSymbol = symbol.substring(0, 1).toUpperCase() + symbol.substring(1);
            atom = new AromaticSymbolAtom(atomSymbol, this.builder);
        } else if ("H".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(1);
        } else if ("D".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(2);
        } else if ("T".equals(symbol)) {
            atom = new HydrogenAtom(this.builder);
            atom.setSymbol(symbol.toUpperCase());
            atom.setMassNumber(3);
        } else {
            atom = new AliphaticSymbolAtom(symbol, this.builder);
        }
        return atom;
    }
}

