/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Iterator;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IChemSequence;

public class ChemFile
extends ChemObject
implements Serializable,
Cloneable,
IChemFile,
IChemObjectListener {
    private static final long serialVersionUID = 1926781734333430132L;
    protected IChemSequence[] chemSequences = new ChemSequence[this.growArraySize];
    protected int chemSequenceCount = 0;
    protected int growArraySize = 4;

    public void addChemSequence(IChemSequence chemSequence) {
        chemSequence.addListener((IChemObjectListener)this);
        if (this.chemSequenceCount + 1 >= this.chemSequences.length) {
            this.growChemSequenceArray();
        }
        this.chemSequences[this.chemSequenceCount] = chemSequence;
        ++this.chemSequenceCount;
        this.notifyChanged();
    }

    public void removeChemSequence(int pos) {
        this.chemSequences[pos].removeListener((IChemObjectListener)this);
        for (int i = pos; i < this.chemSequenceCount - 1; ++i) {
            this.chemSequences[i] = this.chemSequences[i + 1];
        }
        this.chemSequences[this.chemSequenceCount - 1] = null;
        --this.chemSequenceCount;
        this.notifyChanged();
    }

    public Iterable<IChemSequence> chemSequences() {
        return new Iterable<IChemSequence>(){

            @Override
            public Iterator<IChemSequence> iterator() {
                return new ChemSequenceIterator();
            }
        };
    }

    public IChemSequence getChemSequence(int number) {
        return this.chemSequences[number];
    }

    protected void growChemSequenceArray() {
        this.growArraySize = this.chemSequences.length;
        ChemSequence[] newchemSequences = new ChemSequence[this.chemSequences.length + this.growArraySize];
        System.arraycopy(this.chemSequences, 0, newchemSequences, 0, this.chemSequences.length);
        this.chemSequences = newchemSequences;
    }

    public int getChemSequenceCount() {
        return this.chemSequenceCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ChemFile(#S=");
        buffer.append(this.chemSequenceCount);
        if (this.chemSequenceCount > 0) {
            for (IChemSequence iChemSequence : this.chemSequences()) {
                buffer.append(", ");
                buffer.append(iChemSequence.toString());
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemFile clone = (ChemFile)super.clone();
        clone.chemSequenceCount = this.getChemSequenceCount();
        clone.chemSequences = new ChemSequence[clone.chemSequenceCount];
        for (int f = 0; f < clone.chemSequenceCount; ++f) {
            clone.chemSequences[f] = (ChemSequence)((ChemSequence)this.chemSequences[f]).clone();
        }
        return clone;
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }

    private class ChemSequenceIterator
    implements Iterator<IChemSequence> {
        private int pointer = 0;

        private ChemSequenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < ChemFile.this.chemSequenceCount;
        }

        @Override
        public IChemSequence next() {
            return ChemFile.this.chemSequences[this.pointer++];
        }

        @Override
        public void remove() {
            ChemFile.this.removeChemSequence(--this.pointer);
        }
    }
}

