/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Attribute;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLType;

public class CMLAttribute
extends Attribute
implements CMLConstants {
    static final Logger logger = Logger.getLogger(CMLAttribute.class);
    public static final String CONSTANT_TO_SI = "constantToSI";
    public static final String CONVENTION = "convention";
    public static final String DICTREF = "dictRef";
    public static final String ID = "id";
    public static final String MULTIPLIER_TO_SI = "multiplierToSI";
    public static final String TITLE = "title";
    public static final String UNITS = "units";
    protected CMLType cmlType;
    protected String summary;
    protected String description;
    protected String attributeGroupName;

    public CMLAttribute(String name) {
        super(name, "");
    }

    public CMLAttribute(String name, String value) {
        super(name, value);
    }

    protected CMLAttribute(String name, String URI2, String value) throws NamespaceConflictException {
        super(name, URI2, value);
    }

    public CMLAttribute(CMLAttribute att) {
        super((Attribute)att);
        this.cmlType = att.cmlType;
    }

    public CMLAttribute(Attribute att) {
        super(att);
    }

    protected CMLAttribute(Attribute att, String value) {
        this(att.getLocalName());
        this.setCMLValue(value);
    }

    public Node copy() {
        CMLAttribute newAttribute = new CMLAttribute(this);
        newAttribute.setValue(this.getValue());
        return newAttribute;
    }

    public void setAttributeGroupName(String agn) {
        this.attributeGroupName = agn;
    }

    public String getAttributeGroupName() {
        return this.attributeGroupName;
    }

    public int compareTo(Attribute att) {
        if (att == null) {
            return -1;
        }
        if (this == att) {
            return 0;
        }
        int order = 0;
        if (!(att instanceof CMLAttribute)) {
            order = -1;
        }
        CMLAttribute cmlAtt = (CMLAttribute)att;
        if (order != -1 && (this.cmlType != null || cmlAtt.cmlType != null)) {
            order = this.cmlType != null && cmlAtt.cmlType != null ? this.cmlType.compareTo(cmlAtt.cmlType) : -1;
        }
        if (order == 0) {
            order = this.getClass().getName().compareTo(att.getClass().getName());
        }
        if (order == 0) {
            order = this.getLocalName().compareTo(cmlAtt.getLocalName());
        }
        if (order == 0) {
            order = this.getValue().compareTo(cmlAtt.getValue());
        }
        return order == 0 ? 0 : order / Math.abs(order);
    }

    public String getJavaType() {
        return "String";
    }

    public String getJavaSetMethod() {
        return "setCMLValue";
    }

    public String getJavaGetMethod() {
        return "getCMLValue";
    }

    public String getJavaShortClassName() {
        return this.getClass().getSimpleName();
    }

    public CMLType getSchemaType() {
        return this.cmlType;
    }

    public void setSchemaType(CMLType schemaType) {
        this.cmlType = schemaType;
    }

    public Object getCMLValue() {
        return this.getValue();
    }

    public void setCMLValue(String s) {
        this.setValue(s);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String s) {
        if (s != null) {
            this.summary = s;
            if (!this.summary.endsWith(".")) {
                this.summary = this.summary + ".";
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public CMLType getCmlType() {
        return this.cmlType;
    }

    public void setCmlType(CMLType cmlType) {
        this.cmlType = cmlType;
    }
}

