/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.pharmacophore.PharmacophoreAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQuery;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryBond;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.pharmacophore.PharmacophoreMatcherTest")
public class PharmacophoreMatcher {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(PharmacophoreMatcher.class);
    private PharmacophoreQuery pharmacophoreQuery = null;
    private List<List<PharmacophoreAtom>> matchingPAtoms = null;
    private List<List<IBond>> matchingPBonds = null;
    private List<List<RMap>> bondMapping;
    private IAtomContainer pharmacophoreMolecule = null;
    private List<HashMap<IBond, IBond>> bondMapHash = null;

    public PharmacophoreMatcher() {
    }

    public PharmacophoreMatcher(PharmacophoreQuery pharmacophoreQuery) {
        this.pharmacophoreQuery = pharmacophoreQuery;
    }

    @TestMethod(value="testCNSPcore")
    public boolean matches(IAtomContainer atomContainer) throws CDKException {
        return this.matches(atomContainer, true);
    }

    @TestMethod(value="testMatcherQuery1")
    public boolean matches(IAtomContainer atomContainer, boolean initializeTarget) throws CDKException {
        if (!GeometryTools.has3DCoordinates((IAtomContainer)atomContainer)) {
            throw new CDKException("Molecule must have 3D coordinates");
        }
        if (this.pharmacophoreQuery == null) {
            throw new CDKException("Must set the query pharmacophore before matching");
        }
        if (!this.checkQuery((IQueryAtomContainer)this.pharmacophoreQuery)) {
            throw new CDKException("A problem in the query. Make sure all pharmacophore groups of the same symbol have the same same SMARTS");
        }
        String title = (String)atomContainer.getProperty((Object)"cdk:Title");
        if (initializeTarget) {
            this.pharmacophoreMolecule = this.getPharmacophoreMolecule(atomContainer);
        } else {
            for (IAtom iAtom : this.pharmacophoreMolecule.atoms()) {
                PharmacophoreAtom patom = (PharmacophoreAtom)iAtom;
                ArrayList<Integer> tmpList = new ArrayList<Integer>();
                for (int idx : patom.getMatchingAtoms()) {
                    tmpList.add(idx);
                }
                Point3d coords = this.getEffectiveCoordinates(atomContainer, tmpList);
                patom.setPoint3d(coords);
            }
        }
        if (this.pharmacophoreMolecule.getAtomCount() < this.pharmacophoreQuery.getAtomCount()) {
            this.logger.debug((Object)("Target [" + title + "] did not match the query SMARTS. Skipping constraints"));
            return false;
        }
        this.bondMapping = new UniversalIsomorphismTester().getSubgraphMaps(this.pharmacophoreMolecule, (IAtomContainer)this.pharmacophoreQuery);
        this.logger.debug((Object)("  Got " + this.bondMapping.size() + " hits"));
        return this.bondMapping.size() > 0;
    }

    @TestMethod(value="testMatchedBonds")
    public List<List<IBond>> getMatchingPharmacophoreBonds() {
        if (this.bondMapping == null) {
            return null;
        }
        this.matchingPBonds = new ArrayList<List<IBond>>();
        this.bondMapHash = new ArrayList<HashMap<IBond, IBond>>();
        Iterator<List<RMap>> i$ = this.bondMapping.iterator();
        while (i$.hasNext()) {
            List<RMap> aBondMapping;
            List<RMap> list = aBondMapping = i$.next();
            ArrayList<IBond> bondList = new ArrayList<IBond>();
            HashMap<IBond, IBond> tmphash = new HashMap<IBond, IBond>();
            Iterator<RMap> i$2 = list.iterator();
            while (i$2.hasNext()) {
                RMap aList;
                RMap map = aList = i$2.next();
                int bondID = map.getId1();
                bondList.add(this.pharmacophoreMolecule.getBond(bondID));
                tmphash.put(this.pharmacophoreMolecule.getBond(map.getId1()), this.pharmacophoreQuery.getBond(map.getId2()));
            }
            this.bondMapHash.add(tmphash);
            this.matchingPBonds.add(bondList);
        }
        return this.matchingPBonds;
    }

    @TestMethod(value="testMatchedBonds")
    public List<HashMap<IBond, IBond>> getTargetQueryBondMappings() {
        return this.bondMapHash;
    }

    @TestMethod(value="testMatchedAtoms")
    public List<List<PharmacophoreAtom>> getMatchingPharmacophoreAtoms() {
        if (this.pharmacophoreMolecule == null || this.bondMapping == null) {
            return null;
        }
        this.matchingPAtoms = this.getAtomMappings(this.bondMapping, this.pharmacophoreMolecule);
        return this.matchingPAtoms;
    }

    @TestMethod(value="testMatchedAtoms")
    public List<List<PharmacophoreAtom>> getUniqueMatchingPharmacophoreAtoms() {
        Object ilist;
        this.getMatchingPharmacophoreAtoms();
        ArrayList<List<PharmacophoreAtom>> ret = new ArrayList<List<PharmacophoreAtom>>();
        ArrayList<String> tmp = new ArrayList<String>();
        for (List<PharmacophoreAtom> pmatch : this.matchingPAtoms) {
            ilist = new ArrayList();
            for (PharmacophoreAtom patom : pmatch) {
                int[] indices;
                for (int i : indices = patom.getMatchingAtoms()) {
                    if (ilist.contains(i)) continue;
                    ilist.add(i);
                }
            }
            Collections.sort(ilist);
            String s = "";
            Iterator i$ = ilist.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                s = s + i;
            }
            tmp.add(s);
        }
        ArrayList<Object> utmp = new ArrayList<Object>();
        for (int i = 0; i < tmp.size(); ++i) {
            ilist = (String)tmp.get(i);
            if (utmp.contains(ilist)) continue;
            utmp.add(ilist);
            ret.add(this.matchingPAtoms.get(i));
        }
        return ret;
    }

    @TestMethod(value="testGetterSetter")
    public PharmacophoreQuery getPharmacophoreQuery() {
        return this.pharmacophoreQuery;
    }

    @TestMethod(value="testGetterSetter")
    public void setPharmacophoreQuery(PharmacophoreQuery query) {
        this.pharmacophoreQuery = query;
    }

    private IAtomContainer getPharmacophoreMolecule(IAtomContainer atomContainer) throws CDKException {
        SMARTSQueryTool sqt = new SMARTSQueryTool("C", atomContainer.getBuilder());
        IAtomContainer pharmacophoreMolecule = (IAtomContainer)DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[0]);
        HashMap<String, String> map = new HashMap<String, String>();
        this.logger.debug((Object)("Converting [" + atomContainer.getProperty((Object)"cdk:Title") + "] to a pcore molecule"));
        for (IAtom atom : this.pharmacophoreQuery.atoms()) {
            String[] subSmarts;
            PharmacophoreQueryAtom qatom = (PharmacophoreQueryAtom)atom;
            String smarts = qatom.getSmarts();
            if (!map.containsKey(qatom.getSymbol())) {
                map.put(qatom.getSymbol(), smarts);
            } else if (((String)map.get(qatom.getSymbol())).equals(smarts)) continue;
            for (String subSmart : subSmarts = smarts.split("\\|")) {
                sqt.setSmarts(subSmart);
                if (!sqt.matches(atomContainer)) continue;
                List mappings = sqt.getUniqueMatchingAtoms();
                for (List atomIndices : mappings) {
                    Point3d coords = this.getEffectiveCoordinates(atomContainer, atomIndices);
                    PharmacophoreAtom patom = new PharmacophoreAtom(smarts, qatom.getSymbol(), coords);
                    patom.setMatchingAtoms(this.intIndices(atomIndices));
                    if (pharmacophoreMolecule.contains((IAtom)patom)) continue;
                    pharmacophoreMolecule.addAtom((IAtom)patom);
                }
            }
            this.logger.debug((Object)("\tFound " + sqt.getUniqueMatchingAtoms().size() + " unique matches for " + smarts));
        }
        if (this.hasDistanceConstraints((IQueryAtomContainer)this.pharmacophoreQuery)) {
            int npatom = pharmacophoreMolecule.getAtomCount();
            for (int i = 0; i < npatom - 1; ++i) {
                for (int j = i + 1; j < npatom; ++j) {
                    PharmacophoreAtom atom1 = (PharmacophoreAtom)pharmacophoreMolecule.getAtom(i);
                    PharmacophoreAtom atom2 = (PharmacophoreAtom)pharmacophoreMolecule.getAtom(j);
                    PharmacophoreBond bond = new PharmacophoreBond(atom1, atom2);
                    pharmacophoreMolecule.addBond((IBond)bond);
                }
            }
        }
        if (this.hasAngleConstraints((IQueryAtomContainer)this.pharmacophoreQuery)) {
            int nangleDefs = 0;
            for (IBond bond : this.pharmacophoreQuery.bonds()) {
                if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
                IAtom startQAtom = bond.getAtom(0);
                IAtom middleQAtom = bond.getAtom(1);
                IAtom endQAtom = bond.getAtom(2);
                ArrayList<IAtom> startl = new ArrayList<IAtom>();
                ArrayList<IAtom> middlel = new ArrayList<IAtom>();
                ArrayList<IAtom> endl = new ArrayList<IAtom>();
                for (IAtom tatom : pharmacophoreMolecule.atoms()) {
                    if (tatom.getSymbol().equals(startQAtom.getSymbol())) {
                        startl.add(tatom);
                    }
                    if (tatom.getSymbol().equals(middleQAtom.getSymbol())) {
                        middlel.add(tatom);
                    }
                    if (!tatom.getSymbol().equals(endQAtom.getSymbol())) continue;
                    endl.add(tatom);
                }
                ArrayList<IAtom[]> tmpl = new ArrayList<IAtom[]>();
                for (IAtom middle : middlel) {
                    for (IAtom start : startl) {
                        if (middle.equals(start)) continue;
                        for (IAtom end : endl) {
                            if (start.equals(end) || middle.equals(end)) continue;
                            tmpl.add(new IAtom[]{start, middle, end});
                        }
                    }
                }
                ArrayList<IAtom[]> unique = new ArrayList<IAtom[]>();
                for (int i = 0; i < tmpl.size(); ++i) {
                    IAtom[] seq1 = (IAtom[])tmpl.get(i);
                    boolean isRepeat = false;
                    for (int j = 0; j < unique.size(); ++j) {
                        IAtom[] seq2;
                        if (i == j || seq1[1] != (seq2 = (IAtom[])unique.get(j))[1] || seq1[0] != seq2[2] || seq1[2] != seq2[0]) continue;
                        isRepeat = true;
                    }
                    if (isRepeat) continue;
                    unique.add(seq1);
                }
                for (IAtom[] seq : unique) {
                    PharmacophoreAngleBond pbond = new PharmacophoreAngleBond((PharmacophoreAtom)seq[0], (PharmacophoreAtom)seq[1], (PharmacophoreAtom)seq[2]);
                    pharmacophoreMolecule.addBond((IBond)pbond);
                    ++nangleDefs;
                }
            }
            this.logger.debug((Object)("Added " + nangleDefs + " defs to the target pcore molecule"));
        }
        return pharmacophoreMolecule;
    }

    private boolean hasDistanceConstraints(IQueryAtomContainer query) {
        for (IBond bond : query.bonds()) {
            if (!(bond instanceof PharmacophoreQueryBond)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAngleConstraints(IQueryAtomContainer query) {
        for (IBond bond : query.bonds()) {
            if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
            return true;
        }
        return false;
    }

    private int[] intIndices(List<Integer> atomIndices) {
        int[] ret = new int[atomIndices.size()];
        for (int i = 0; i < atomIndices.size(); ++i) {
            ret[i] = atomIndices.get(i);
        }
        return ret;
    }

    private Point3d getEffectiveCoordinates(IAtomContainer atomContainer, List<Integer> atomIndices) {
        Point3d ret = new Point3d(0.0, 0.0, 0.0);
        for (Integer atomIndice : atomIndices) {
            int atomIndex = atomIndice;
            Point3d coord = atomContainer.getAtom(atomIndex).getPoint3d();
            ret.x += coord.x;
            ret.y += coord.y;
            ret.z += coord.z;
        }
        ret.x /= (double)atomIndices.size();
        ret.y /= (double)atomIndices.size();
        ret.z /= (double)atomIndices.size();
        return ret;
    }

    private List<List<PharmacophoreAtom>> getAtomMappings(List<List<RMap>> bondMapping, IAtomContainer atomContainer) {
        ArrayList<List<PharmacophoreAtom>> atomMapping = new ArrayList<List<PharmacophoreAtom>>();
        Iterator<List<RMap>> i$ = bondMapping.iterator();
        while (i$.hasNext()) {
            List<RMap> aBondMapping;
            List<RMap> list = aBondMapping = i$.next();
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            ArrayList<PharmacophoreAtom> atomList = new ArrayList<PharmacophoreAtom>();
            Iterator<RMap> i$2 = list.iterator();
            while (i$2.hasNext()) {
                RMap aList;
                RMap map = aList = i$2.next();
                int bondID = map.getId1();
                IBond bond = atomContainer.getBond(bondID);
                IAtom atom1 = bond.getAtom(0);
                IAtom atom2 = bond.getAtom(1);
                Integer idx1 = atomContainer.getAtomNumber(atom1);
                Integer idx2 = atomContainer.getAtomNumber(atom2);
                if (!tmp.contains(idx1)) {
                    tmp.add(idx1);
                    atomList.add(new PharmacophoreAtom((PharmacophoreAtom)atom1));
                }
                if (tmp.contains(idx2)) continue;
                tmp.add(idx2);
                atomList.add(new PharmacophoreAtom((PharmacophoreAtom)atom2));
            }
            if (tmp.size() <= 0) continue;
            atomMapping.add(atomList);
        }
        return atomMapping;
    }

    private boolean checkQuery(IQueryAtomContainer query) {
        if (!(query instanceof PharmacophoreQuery)) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < query.getAtomCount(); ++i) {
            IQueryAtom atom = (IQueryAtom)query.getAtom(i);
            if (!(atom instanceof PharmacophoreQueryAtom)) {
                return false;
            }
            PharmacophoreQueryAtom pqatom = (PharmacophoreQueryAtom)atom;
            String label = pqatom.getSymbol();
            String smarts = pqatom.getSmarts();
            if (!map.containsKey(label)) {
                map.put(label, smarts);
                continue;
            }
            if (((String)map.get(label)).equals(smarts)) continue;
            return false;
        }
        return true;
    }
}

