/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.io.IOException;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.charges.InductivePartialChargesTest")
public class InductivePartialCharges
implements IChargeCalculator {
    private static double[] pauling;
    private IsotopeFactory ifac = null;
    private AtomTypeFactory factory = null;
    private static ILoggingTool logger;

    public InductivePartialCharges() throws IOException, ClassNotFoundException {
        if (pauling == null) {
            pauling = new double[]{0.0, 2.1, 0.0, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 0.0, 0.9, 1.2, 1.5, 1.8, 2.1, 2.5, 3.0, 0.0, 0.8, 1.0, 1.3, 1.5, 1.6, 1.6, 1.5, 1.8, 1.8, 1.8, 1.9, 1.6, 1.6, 1.8, 2.0, 2.4, 2.8, 0.0, 0.8, 1.0, 1.3, 1.4, 1.6, 1.8, 1.9, 2.2, 2.2, 2.2, 1.9, 1.7, 1.7, 1.8, 1.9, 2.1, 2.5, 0.7, 0.9, 1.1, 1.3, 1.5, 1.7, 1.9, 2.2, 2.2, 2.2, 2.4, 1.9, 1.8, 1.8, 1.9, 2.0, 2.2, 0.0, 0.7, 0.9, 1.1};
        }
    }

    @TestMethod(value="testInductivePartialCharges")
    public IAtomContainer assignInductivePartialCharges(IAtomContainer ac) throws Exception {
        if (this.factory == null) {
            this.factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)ac.getBuilder());
        }
        int stepsLimit = 9;
        IAtom[] atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)ac);
        double[] pChInch = new double[atoms.length * (stepsLimit + 1)];
        double[] ElEn = new double[atoms.length * (stepsLimit + 1)];
        double[] pCh = new double[atoms.length * (stepsLimit + 1)];
        double[] startEE = this.getPaulingElectronegativities(ac, true);
        for (int e = 0; e < atoms.length; ++e) {
            ElEn[e] = startEE[e];
        }
        for (int s = 1; s < 10; ++s) {
            for (int a = 0; a < atoms.length; ++a) {
                pChInch[a + s * atoms.length] = this.getAtomicChargeIncrement(ac, a, ElEn, s);
                pCh[a + s * atoms.length] = pChInch[a + s * atoms.length] + pCh[a + (s - 1) * atoms.length];
                ElEn[a + s * atoms.length] = ElEn[a + (s - 1) * atoms.length] + pChInch[a + s * atoms.length] / this.getAtomicSoftnessCore(ac, a);
                if (s != 9) continue;
                atoms[a].setProperty((Object)"InductivePartialCharge", (Object)new Double(pCh[a + s * atoms.length]));
                atoms[a].setProperty((Object)"EffectiveAtomicElectronegativity", (Object)new Double(ElEn[a + s * atoms.length]));
            }
        }
        return ac;
    }

    @Override
    @TestMethod(value="testCalculateCharges_IAtomContainer")
    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.assignInductivePartialCharges(container);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate inductive partial charges: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @TestMethod(value="testGetPaulingElectronegativities")
    public double[] getPaulingElectronegativities(IAtomContainer ac, boolean modified) throws CDKException {
        double[] paulingElectronegativities = new double[ac.getAtomCount()];
        IElement element = null;
        String symbol = null;
        int atomicNumber = 0;
        try {
            this.ifac = Isotopes.getInstance();
            for (int i = 0; i < ac.getAtomCount(); ++i) {
                IAtom atom = ac.getAtom(i);
                symbol = ac.getAtom(i).getSymbol();
                element = this.ifac.getElement(symbol);
                atomicNumber = element.getAtomicNumber();
                if (modified) {
                    if (symbol.equals("Cl")) {
                        paulingElectronegativities[i] = 3.28;
                        continue;
                    }
                    if (symbol.equals("Br")) {
                        paulingElectronegativities[i] = 3.13;
                        continue;
                    }
                    if (symbol.equals("I")) {
                        paulingElectronegativities[i] = 2.93;
                        continue;
                    }
                    if (symbol.equals("H")) {
                        paulingElectronegativities[i] = 2.1;
                        continue;
                    }
                    if (symbol.equals("C")) {
                        if (ac.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                            paulingElectronegativities[i] = 2.2;
                            continue;
                        }
                        if (ac.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                            paulingElectronegativities[i] = 2.31;
                            continue;
                        }
                        paulingElectronegativities[i] = 3.15;
                        continue;
                    }
                    if (symbol.equals("O")) {
                        if (ac.getMaximumBondOrder(atom) == IBond.Order.SINGLE) {
                            paulingElectronegativities[i] = 3.2;
                            continue;
                        }
                        if (ac.getMaximumBondOrder(atom) == IBond.Order.SINGLE) continue;
                        paulingElectronegativities[i] = 4.34;
                        continue;
                    }
                    if (symbol.equals("Si")) {
                        paulingElectronegativities[i] = 1.99;
                        continue;
                    }
                    if (symbol.equals("S")) {
                        paulingElectronegativities[i] = 2.74;
                        continue;
                    }
                    if (symbol.equals("N")) {
                        paulingElectronegativities[i] = 2.59;
                        continue;
                    }
                    paulingElectronegativities[i] = pauling[atomicNumber];
                    continue;
                }
                paulingElectronegativities[i] = pauling[atomicNumber];
            }
            return paulingElectronegativities;
        }
        catch (Exception ex1) {
            logger.debug((Object)ex1);
            throw new CDKException("Problems with IsotopeFactory due to " + ex1.toString(), (Throwable)ex1);
        }
    }

    @TestMethod(value="testGetAtomicSoftness")
    public double getAtomicSoftnessCore(IAtomContainer ac, int atomPosition) throws CDKException {
        if (this.factory == null) {
            this.factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)ac.getBuilder());
        }
        IAtom target = null;
        double core = 0.0;
        double radiusTarget = 0.0;
        target = ac.getAtom(atomPosition);
        double partial = 0.0;
        double radius = 0.0;
        String symbol = null;
        IAtomType type = null;
        try {
            symbol = ac.getAtom(atomPosition).getSymbol();
            type = this.factory.getAtomType(symbol);
            radiusTarget = this.getCovalentRadius(symbol, ac.getMaximumBondOrder(target)) > 0.0 ? this.getCovalentRadius(symbol, ac.getMaximumBondOrder(target)) : type.getCovalentRadius().doubleValue();
        }
        catch (Exception ex1) {
            logger.debug((Object)ex1);
            throw new CDKException("Problems with AtomTypeFactory due to " + ex1.getMessage(), (Throwable)ex1);
        }
        for (IAtom atom : ac.atoms()) {
            if (target.equals(atom)) continue;
            symbol = atom.getSymbol();
            partial = 0.0;
            try {
                type = this.factory.getAtomType(symbol);
            }
            catch (Exception ex1) {
                logger.debug((Object)ex1);
                throw new CDKException("Problems with AtomTypeFactory due to " + ex1.getMessage(), (Throwable)ex1);
            }
            radius = this.getCovalentRadius(symbol, ac.getMaximumBondOrder(atom)) > 0.0 ? this.getCovalentRadius(symbol, ac.getMaximumBondOrder(atom)) : type.getCovalentRadius().doubleValue();
            partial += radius * radius;
            partial += radiusTarget * radiusTarget;
            core += (partial /= this.calculateSquaredDistanceBetweenTwoAtoms(target, atom));
        }
        core = 2.0 * core;
        core = 0.172 * core;
        return core;
    }

    private double getAtomicChargeIncrement(IAtomContainer ac, int atomPosition, double[] ElEn, int as) throws CDKException {
        IAtom[] allAtoms = null;
        IAtom target = null;
        double incrementedCharge = 0.0;
        double radiusTarget = 0.0;
        target = ac.getAtom(atomPosition);
        allAtoms = AtomContainerManipulator.getAtomArray((IAtomContainer)ac);
        double tmp = 0.0;
        double radius = 0.0;
        String symbol = null;
        IAtomType type = null;
        try {
            symbol = target.getSymbol();
            type = this.factory.getAtomType(symbol);
            radiusTarget = this.getCovalentRadius(symbol, ac.getMaximumBondOrder(target)) > 0.0 ? this.getCovalentRadius(symbol, ac.getMaximumBondOrder(target)) : type.getCovalentRadius().doubleValue();
        }
        catch (Exception ex1) {
            logger.debug((Object)ex1);
            throw new CDKException("Problems with AtomTypeFactory due to " + ex1.getMessage(), (Throwable)ex1);
        }
        for (int a = 0; a < allAtoms.length; ++a) {
            if (target.equals(allAtoms[a])) continue;
            tmp = 0.0;
            symbol = allAtoms[a].getSymbol();
            try {
                type = this.factory.getAtomType(symbol);
            }
            catch (Exception ex1) {
                logger.debug((Object)ex1);
                throw new CDKException("Problems with AtomTypeFactory due to " + ex1.getMessage(), (Throwable)ex1);
            }
            radius = this.getCovalentRadius(symbol, ac.getMaximumBondOrder(allAtoms[a])) > 0.0 ? this.getCovalentRadius(symbol, ac.getMaximumBondOrder(allAtoms[a])) : type.getCovalentRadius().doubleValue();
            tmp = ElEn[a + (as - 1) * allAtoms.length] - ElEn[atomPosition + (as - 1) * allAtoms.length];
            tmp *= radius * radius + radiusTarget * radiusTarget;
            incrementedCharge += (tmp /= this.calculateSquaredDistanceBetweenTwoAtoms(target, allAtoms[a]));
        }
        incrementedCharge = 0.172 * incrementedCharge;
        return incrementedCharge;
    }

    private double getCovalentRadius(String symbol, IBond.Order maxBondOrder) {
        double radiusTarget = 0.0;
        if (symbol.equals("F")) {
            radiusTarget = 0.64;
        } else if (symbol.equals("Cl")) {
            radiusTarget = 0.99;
        } else if (symbol.equals("Br")) {
            radiusTarget = 1.14;
        } else if (symbol.equals("I")) {
            radiusTarget = 1.33;
        } else if (symbol.equals("H")) {
            radiusTarget = 0.3;
        } else if (symbol.equals("C")) {
            radiusTarget = maxBondOrder == IBond.Order.SINGLE ? 0.77 : (maxBondOrder == IBond.Order.DOUBLE ? 0.67 : 0.6);
        } else if (symbol.equals("O")) {
            if (maxBondOrder == IBond.Order.SINGLE) {
                radiusTarget = 0.66;
            } else if (maxBondOrder != IBond.Order.SINGLE) {
                radiusTarget = 0.6;
            }
        } else {
            radiusTarget = symbol.equals("Si") ? 1.11 : (symbol.equals("S") ? 1.04 : (symbol.equals("N") ? 0.7 : 0.0));
        }
        return radiusTarget;
    }

    private double calculateSquaredDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        double distance = 0.0;
        double tmp = 0.0;
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        tmp = firstPoint.distance(secondPoint);
        distance = tmp * tmp;
        return distance;
    }

    static {
        logger = LoggingToolFactory.createLoggingTool(InductivePartialCharges.class);
    }
}

