/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.silent.Monomer;
import org.openscience.cdk.silent.Polymer;
import org.openscience.cdk.silent.Strand;

public class BioPolymer
extends Polymer
implements Serializable,
IBioPolymer {
    private static final long serialVersionUID = -5001873073769634393L;
    private Map<String, IStrand> strands = new Hashtable<String, IStrand>();

    public void addAtom(IAtom oAtom, IStrand oStrand) {
        int atomCount = super.getAtomCount();
        super.addAtom(oAtom);
        if (atomCount != super.getAtomCount() && oStrand != null) {
            oStrand.addAtom(oAtom);
            if (!this.strands.containsKey(oStrand.getStrandName())) {
                this.strands.put(oStrand.getStrandName(), oStrand);
            }
        }
    }

    public void addAtom(IAtom oAtom, IMonomer oMonomer, IStrand oStrand) {
        int atomCount = super.getAtomCount();
        super.addAtom(oAtom);
        if (atomCount != super.getAtomCount() && oStrand != null) {
            oStrand.addAtom(oAtom, oMonomer);
            if (!this.strands.containsKey(oStrand.getStrandName())) {
                this.strands.put(oStrand.getStrandName(), oStrand);
            }
        }
    }

    @Override
    public int getMonomerCount() {
        Iterator<String> keys = this.strands.keySet().iterator();
        int number = 0;
        if (!keys.hasNext()) {
            return super.getMonomerCount();
        }
        while (keys.hasNext()) {
            Strand tmp = (Strand)this.strands.get(keys.next());
            number += tmp.getMonomers().size() - 1;
        }
        return number;
    }

    public IMonomer getMonomer(String monName, String strandName) {
        Strand strand = (Strand)this.strands.get(strandName);
        if (strand != null) {
            return (Monomer)strand.getMonomer(monName);
        }
        return null;
    }

    @Override
    public Collection<String> getMonomerNames() {
        Iterator<String> keys = this.strands.keySet().iterator();
        Hashtable<String, IMonomer> monomers = new Hashtable<String, IMonomer>();
        if (!keys.hasNext()) {
            return super.getMonomerNames();
        }
        while (keys.hasNext()) {
            Strand oStrand = (Strand)this.strands.get(keys.next());
            monomers.putAll(oStrand.getMonomers());
        }
        return monomers.keySet();
    }

    public int getStrandCount() {
        return this.strands.size();
    }

    public IStrand getStrand(String cName) {
        return (Strand)this.strands.get(cName);
    }

    public Collection<String> getStrandNames() {
        return this.strands.keySet();
    }

    public void removeStrand(String name) {
        if (this.strands.containsKey(name)) {
            Strand strand = (Strand)this.strands.get(name);
            this.remove(strand);
            this.strands.remove(name);
        }
    }

    public Map<String, IStrand> getStrands() {
        return this.strands;
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("BioPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    public IBioPolymer clone() throws CloneNotSupportedException {
        BioPolymer clone = (BioPolymer)super.clone();
        clone.strands.clear();
        Iterator<String> strands = clone.getStrandNames().iterator();
        while (strands.hasNext()) {
            Strand strand = (Strand)clone.getStrand(strands.next().toString()).clone();
            Iterator<String> iter = strand.getMonomerNames().iterator();
            while (iter.hasNext()) {
                IMonomer monomer = strand.getMonomer(iter.next().toString());
                Iterator atoms = monomer.atoms().iterator();
                while (atoms.hasNext()) {
                    clone.addAtom((IAtom)atoms.next(), monomer, strand);
                }
            }
        }
        return clone;
    }
}

