/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;

@TestClass(value="org.openscience.cdk.tools.CDKHydrogenAdderTest")
public class CDKHydrogenAdder {
    private AtomTypeFactory atomTypeList;
    private static final String ATOM_TYPE_LIST = "org/openscience/cdk/dict/data/cdk-atom-types.owl";
    private static Map<String, CDKHydrogenAdder> tables = new Hashtable<String, CDKHydrogenAdder>(3);

    private CDKHydrogenAdder(IChemObjectBuilder builder) {
        if (this.atomTypeList == null) {
            this.atomTypeList = AtomTypeFactory.getInstance(ATOM_TYPE_LIST, builder);
        }
    }

    @TestMethod(value="testInstance")
    public static CDKHydrogenAdder getInstance(IChemObjectBuilder builder) {
        if (!tables.containsKey(builder.getClass().getName())) {
            tables.put(builder.getClass().getName(), new CDKHydrogenAdder(builder));
        }
        return tables.get(builder.getClass().getName());
    }

    @TestMethod(value="testMethane,testFormaldehyde,testHCN")
    public void addImplicitHydrogens(IAtomContainer container) throws CDKException {
        for (IAtom atom : container.atoms()) {
            if (atom instanceof IPseudoAtom) continue;
            this.addImplicitHydrogens(container, atom);
        }
    }

    @TestMethod(value="testImpHByAtom")
    public void addImplicitHydrogens(IAtomContainer container, IAtom atom) throws CDKException {
        if (atom.getAtomTypeName() == null) {
            throw new CDKException("IAtom is not typed! " + atom.getSymbol());
        }
        if ("X".equals(atom.getAtomTypeName())) {
            if (atom.getImplicitHydrogenCount() == null) {
                atom.setImplicitHydrogenCount(0);
            }
            return;
        }
        IAtomType type = this.atomTypeList.getAtomType(atom.getAtomTypeName());
        if (type == null) {
            throw new CDKException("Atom type is not a recognized CDK atom type: " + atom.getAtomTypeName());
        }
        if (type.getFormalNeighbourCount() == CDKConstants.UNSET) {
            throw new CDKException("Atom type is too general; cannot decide the number of implicit hydrogen to add for: " + atom.getAtomTypeName());
        }
        atom.setImplicitHydrogenCount(type.getFormalNeighbourCount() - container.getConnectedAtomsCount(atom));
    }
}

