/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.tools.LoggingToolFactory;

final class CorrectGeometricConfiguration {
    private final IAtomContainer container;
    private final int[][] graph;
    private final Map<IAtom, Integer> atomToIndex;
    private final RingSearch ringSearch;
    private final boolean[] visited;

    public static IAtomContainer correct(IAtomContainer container) {
        if (!Iterables.isEmpty(container.stereoElements())) {
            new CorrectGeometricConfiguration(container);
        }
        return container;
    }

    CorrectGeometricConfiguration(IAtomContainer container) {
        this(container, GraphUtil.toAdjList(container));
    }

    CorrectGeometricConfiguration(IAtomContainer container, int[][] graph) {
        this.container = container;
        this.graph = graph;
        this.visited = new boolean[graph.length];
        this.atomToIndex = Maps.newHashMapWithExpectedSize(container.getAtomCount());
        this.ringSearch = new RingSearch(container, graph);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            this.atomToIndex.put(atom, i);
            if (atom.getPoint2d() != null) continue;
            throw new IllegalArgumentException("atom " + i + " had unset coordinates");
        }
        for (IStereoElement element : container.stereoElements()) {
            if (!(element instanceof IDoubleBondStereochemistry)) continue;
            this.adjust((IDoubleBondStereochemistry)element);
        }
    }

    private void adjust(IDoubleBondStereochemistry dbs) {
        IBond db = dbs.getStereoBond();
        IBond[] bonds = dbs.getBonds();
        IAtom left = db.getAtom(0);
        IAtom right = db.getAtom(1);
        int p = CorrectGeometricConfiguration.parity(dbs);
        int q = CorrectGeometricConfiguration.parity(this.getAtoms(left, bonds[0].getConnectedAtom(left), right)) * CorrectGeometricConfiguration.parity(this.getAtoms(right, bonds[1].getConnectedAtom(right), left));
        if (p == 0) {
            for (IBond bond : this.container.getConnectedBondsList(left)) {
                bond.setStereo(IBond.Stereo.NONE);
            }
            for (IBond bond : this.container.getConnectedBondsList(right)) {
                bond.setStereo(IBond.Stereo.NONE);
            }
            bonds[0].setStereo(IBond.Stereo.UP_OR_DOWN);
            return;
        }
        if (p == q) {
            return;
        }
        if (this.ringSearch.cyclic(this.atomToIndex.get(left), this.atomToIndex.get(right))) {
            LoggingToolFactory.createLoggingTool(this.getClass()).error("cannot correct cyclic double-bond stereo configuration");
            return;
        }
        Arrays.fill(this.visited, false);
        this.visited[this.atomToIndex.get((Object)left).intValue()] = true;
        for (int w : this.graph[this.atomToIndex.get(right)]) {
            if (this.visited[w]) continue;
            this.reflect(w, db);
        }
    }

    private IAtom[] getAtoms(IAtom focus, IAtom substituent, IAtom otherFocus) {
        IAtom otherSubstituent = focus;
        for (int w : this.graph[this.atomToIndex.get(focus)]) {
            IAtom atom = this.container.getAtom(w);
            if (atom == substituent || atom == otherFocus) continue;
            otherSubstituent = atom;
        }
        return new IAtom[]{substituent, otherSubstituent, otherFocus};
    }

    private static int parity(IDoubleBondStereochemistry element) {
        switch (element.getStereo()) {
            case TOGETHER: {
                return -1;
            }
            case OPPOSITE: {
                return 1;
            }
        }
        return 0;
    }

    private static int parity(IAtom[] atoms) {
        return CorrectGeometricConfiguration.parity(atoms[0].getPoint2d(), atoms[1].getPoint2d(), atoms[2].getPoint2d());
    }

    private static int parity(Point2d a, Point2d b, Point2d c) {
        double det = (a.x - c.x) * (b.y - c.y) - (a.y - c.y) * (b.x - c.x);
        return (int)Math.signum(det);
    }

    private void reflect(int v, IBond bond) {
        this.visited[v] = true;
        IAtom atom = this.container.getAtom(v);
        atom.setPoint2d(this.reflect(atom.getPoint2d(), bond));
        for (int w : this.graph[v]) {
            if (this.visited[w]) continue;
            this.reflect(w, bond);
        }
    }

    private Point2d reflect(Point2d p, IBond bond) {
        IAtom a = bond.getAtom(0);
        IAtom b = bond.getAtom(1);
        return this.reflect(p, a.getPoint2d().x, a.getPoint2d().y, b.getPoint2d().x, b.getPoint2d().y);
    }

    private Point2d reflect(Point2d p, double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double a = (dx * dx - dy * dy) / (dx * dx + dy * dy);
        double b = 2.0 * dx * dy / (dx * dx + dy * dy);
        return new Point2d(a * (p.x - x0) + b * (p.y - y0) + x0, b * (p.x - x0) - a * (p.y - y0) + y0);
    }
}

