/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.beam.AllCycles;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Function;
import uk.ac.ebi.beam.Generator;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Localise;
import uk.ac.ebi.beam.Parser;
import uk.ac.ebi.beam.Topology;

public final class Graph {
    private Atom[] atoms;
    private List<Edge>[] edges;
    private Map<Integer, Topology> topologies;
    private int order = 0;
    private int size = 0;
    private boolean delocalised;

    Graph(int expSize) {
        this.edges = new List[expSize];
        for (int i = 0; i < expSize; ++i) {
            this.edges[i] = new ArrayList<Edge>(4);
        }
        this.atoms = new Atom[expSize];
        this.topologies = new HashMap<Integer, Topology>(10);
    }

    void setAtom(int i, Atom a) {
        this.atoms[i] = a;
    }

    private void ensureCapacity() {
        if (this.order >= this.atoms.length) {
            this.atoms = Arrays.copyOf(this.atoms, this.order * 2);
            this.edges = Arrays.copyOf(this.edges, this.order * 2);
            for (int i = this.order; i < this.edges.length; ++i) {
                this.edges[i] = new ArrayList<Edge>(4);
            }
        }
    }

    int addAtom(Atom a) {
        this.ensureCapacity();
        this.atoms[this.order++] = a;
        this.delocalised |= a.aromatic();
        return this.order - 1;
    }

    public Atom atom(int i) {
        return this.atoms[this.checkRange(i)];
    }

    void addEdge(Edge e) {
        int u = this.checkRange(e.either());
        int v = this.checkRange(e.other(u));
        this.edges[u].add(e);
        this.edges[v].add(e);
        ++this.size;
    }

    int degree(int u) {
        return this.edges[this.checkRange(u)].size();
    }

    public List<Edge> edges(int u) {
        return Collections.unmodifiableList(this.edges[this.checkRange(u)]);
    }

    public int[] neighbors(int u) {
        List<Edge> es = this.edges[this.checkRange(u)];
        int[] vs = new int[es.size()];
        int deg = es.size();
        for (int i = 0; i < deg; ++i) {
            vs[i] = es.get(i).other(u);
        }
        Arrays.sort(vs);
        return vs;
    }

    public boolean adjacent(int u, int v) {
        this.checkRange(v);
        for (Edge e : this.edges(u)) {
            if (e.other(u) != v) continue;
            return true;
        }
        return false;
    }

    public int implHCount(int u) {
        return this.atom(this.checkRange(u)).hydrogens(this, u);
    }

    public Edge edge(int u, int v) {
        for (Edge e : this.edges(u)) {
            if (e.other(u) != v) continue;
            return e;
        }
        throw new IllegalArgumentException(u + ", " + v + " are not adjacent");
    }

    void replace(Edge org, Edge rep) {
        int i;
        int u = org.either();
        int v = org.other(u);
        for (i = 0; i < this.edges[u].size(); ++i) {
            if (this.edges[u].get(i) != org) continue;
            this.edges[u].set(i, rep);
        }
        for (i = 0; i < this.edges[v].size(); ++i) {
            if (this.edges[v].get(i) != org) continue;
            this.edges[v].set(i, rep);
        }
    }

    boolean addTopology(Topology t) {
        if (t == Topology.unknown()) {
            return false;
        }
        return this.topologies.put(t.atom(), t) != null;
    }

    Topology topologyOf(int u) {
        Topology t = this.topologies.get(u);
        return t != null ? t : Topology.unknown();
    }

    public Configuration configurationOf(int u) {
        Topology t = this.topologyOf(u);
        if (t == Topology.unknown()) {
            return t.configuration();
        }
        int[] p = new int[this.order];
        for (int i = 0; i < this.order; ++i) {
            p[i] = i;
        }
        return t.orderBy(p).configuration();
    }

    public int order() {
        return this.order;
    }

    public int size() {
        return this.size;
    }

    public static Graph fromSmiles(String smi) throws IOException {
        if (smi == null) {
            throw new NullPointerException("no SMILES provided");
        }
        return Parser.parse(smi);
    }

    public String toSmiles() {
        return Generator.generate(this);
    }

    public Graph aromatic() {
        return AllCycles.daylightModel(this).aromaticForm();
    }

    public Graph kekule() throws InvalidSmilesException {
        return Localise.localise(this);
    }

    Graph permute(int[] p) {
        int u;
        if (p.length != this.order) {
            throw new IllegalArgumentException("permuation size should equal |V| (order)");
        }
        Graph g = new Graph(this.order);
        g.order = this.order;
        g.size = this.size;
        for (u = 0; u < this.order; ++u) {
            g.atoms[p[u]] = this.atoms[u];
            g.addTopology(this.topologyOf(u).transform(p));
        }
        for (u = 0; u < this.order; ++u) {
            for (Edge e : this.edges[u]) {
                if (u >= e.other(u)) continue;
                int v = p[u];
                int w = p[e.other(u)];
                Edge f = new Edge(v, w, e.bond(u));
                g.edges[v].add(f);
                g.edges[w].add(f);
            }
        }
        return g.sort();
    }

    public Iterable<Atom> atoms() {
        return Arrays.asList(this.atoms).subList(0, this.order);
    }

    public Iterable<Edge> edges() {
        ArrayList<Edge> es = new ArrayList<Edge>(this.size);
        for (int u = 0; u < this.order; ++u) {
            for (Edge e : this.edges[u]) {
                if (e.other(u) >= u) continue;
                es.add(e);
            }
        }
        return Collections.unmodifiableCollection(es);
    }

    <T> T apply(Function<Graph, T> f) throws Exception {
        return f.apply(this);
    }

    Graph sort() {
        for (int u = 0; u < this.order; ++u) {
            Collections.sort(this.edges[u], EdgeComparator.forVertex(u));
        }
        return this;
    }

    void clear() {
        this.topologies.clear();
        for (int i = 0; i < this.order; ++i) {
            this.atoms[i] = null;
            this.edges[i].clear();
        }
        this.order = 0;
        this.size = 0;
    }

    void markDelocalised() {
        this.delocalised = true;
    }

    boolean isDelocalised() {
        return this.delocalised;
    }

    private int checkRange(int u) {
        if (u < 0 || u >= this.order) {
            throw new IllegalArgumentException("invalid atom index: " + u);
        }
        return u;
    }

    private static final class EdgeComparator
    implements Comparator<Edge> {
        private int u;

        private EdgeComparator(int u) {
            this.u = u;
        }

        static EdgeComparator forVertex(int u) {
            return new EdgeComparator(u);
        }

        @Override
        public int compare(Edge e, Edge f) {
            int w;
            int v = e.other(this.u);
            if (v > (w = f.other(this.u))) {
                return 1;
            }
            if (v < w) {
                return -1;
            }
            return 0;
        }
    }
}

