/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.ToSubsetAtoms;
import uk.ac.ebi.beam.Topology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FromTrigonalTopology
extends AbstractFunction<Graph, Graph> {
    FromTrigonalTopology() {
    }

    @Override
    public Graph apply(Graph g) {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            if (g.topologyOf(u).type() == Configuration.Type.DoubleBond) {
                h.addAtom(this.reducedAtom(g, u));
                continue;
            }
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        Map replacements = new Traversal(g).replacement;
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h.addEdge(e);
            }
        }
        return h;
    }

    private Atom reducedAtom(Graph g, int u) {
        Atom a = g.atom(u);
        int sum = 0;
        for (Edge e : g.edges(u)) {
            sum += e.bond().order();
        }
        return ToSubsetAtoms.toSubset(g.atom(u), sum);
    }

    private static final class Traversal {
        private final Graph g;
        private final boolean[] visited;
        private final int[] ordering;
        private int i;
        private Map<Edge, Edge> replacement = new HashMap<Edge, Edge>();
        private static final Bond[] labels = new Bond[]{Bond.DOWN, Bond.UP};

        private Traversal(Graph g) {
            this.g = g;
            this.visited = new boolean[g.order()];
            this.ordering = new int[g.order()];
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u]) continue;
                this.visit(u, u);
            }
        }

        private void visit(int p, int u) {
            this.visited[u] = true;
            int offset = -1;
            List<Edge> es = this.g.edges(u);
            for (int i = 0; i < es.size(); ++i) {
                Edge e = es.get(i);
                int v = e.other(u);
                if (!this.visited[v]) {
                    this.visit(u, v);
                }
                this.ordering[v] = 2 + i;
                if (e.bond() != Bond.DOUBLE) continue;
                offset = i;
            }
            this.ordering[p] = 0;
            this.ordering[u] = 1;
            Topology t = this.g.topologyOf(u);
            if (t.type() == Configuration.Type.DoubleBond) {
                int j;
                if (offset < 0) {
                    throw new IllegalArgumentException("found atom-centric double bondspecifiation but no double bond label.");
                }
                Topology topology = t.orderBy(this.ordering);
                int n = j = topology.configuration().shorthand() == Configuration.ANTI_CLOCKWISE ? 0 : 1;
                if (this.ordering[es.get(offset).other(u)] >= this.ordering[u] && es.size() == 2 && this.ordering[u] < this.ordering[es.get((offset + 1) % es.size()).other(u)]) {
                    ++j;
                }
                for (int i = 1; i < es.size(); ++i) {
                    Edge e = es.get((offset + i) % es.size());
                    Bond label = labels[j++ % 2];
                    Edge f = new Edge(u, e.other(u), label);
                    Edge existing = this.replacement.get(e);
                    if (existing != null && existing.bond(u) != label) {
                        BitSet visited = new BitSet();
                        visited.set(u);
                        this.invertExistingDirectionalLabels(visited, e.other(u));
                    }
                    this.replacement.put(e, f);
                }
            }
        }

        private void invertExistingDirectionalLabels(BitSet visited, int u) {
            visited.set(u);
            if (this.g.topologyOf(u) == null) {
                return;
            }
            for (Edge e : this.g.edges(u)) {
                int v = e.other(u);
                if (visited.get(v)) continue;
                Edge f = this.replacement.get(e);
                if (f != null) {
                    this.replacement.put(e, f.inverse());
                }
                this.invertExistingDirectionalLabels(visited, v);
            }
        }
    }
}

