/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.graph.PathToolsTest")
public class PathTools {
    public static final boolean DEBUG = false;

    @TestMethod(value="testGetInt2DColumnSum_arrayintint")
    public static int[] getInt2DColumnSum(int[][] apsp) {
        int[] colSum = new int[apsp.length];
        for (int i = 0; i < apsp.length; ++i) {
            int sum = 0;
            for (int j = 0; j < apsp.length; ++j) {
                sum += apsp[i][j];
            }
            colSum[i] = sum;
        }
        return colSum;
    }

    @TestMethod(value="testComputeFloydAPSP_arrayintint")
    public static int[][] computeFloydAPSP(int[][] costMatrix) {
        int j;
        int i;
        int nrow = costMatrix.length;
        int[][] distMatrix = new int[nrow][nrow];
        for (i = 0; i < nrow; ++i) {
            for (j = 0; j < nrow; ++j) {
                distMatrix[i][j] = costMatrix[i][j] == 0 ? 999999999 : 1;
            }
        }
        for (i = 0; i < nrow; ++i) {
            distMatrix[i][i] = 0;
        }
        for (int k = 0; k < nrow; ++k) {
            for (i = 0; i < nrow; ++i) {
                for (j = 0; j < nrow; ++j) {
                    if (distMatrix[i][k] + distMatrix[k][j] >= distMatrix[i][j]) continue;
                    distMatrix[i][j] = distMatrix[i][k] + distMatrix[k][j];
                }
            }
        }
        return distMatrix;
    }

    @TestMethod(value="testComputeFloydAPSP_arraydoubledouble")
    public static int[][] computeFloydAPSP(double[][] costMatrix) {
        int nrow = costMatrix.length;
        int[][] distMatrix = new int[nrow][nrow];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < nrow; ++j) {
                distMatrix[i][j] = costMatrix[i][j] == 0.0 ? 0 : 1;
            }
        }
        return PathTools.computeFloydAPSP(distMatrix);
    }

    @TestMethod(value="testDepthFirstTargetSearch_IAtomContainer_IAtom_IAtom_IAtomContainer")
    public static boolean depthFirstTargetSearch(IAtomContainer molecule, IAtom root, IAtom target, IAtomContainer path) {
        List<IBond> bonds = molecule.getConnectedBondsList(root);
        root.setFlag(16, true);
        for (IBond bond : bonds) {
            IAtom nextAtom = bond.getConnectedAtom(root);
            if (nextAtom.getFlag(16)) continue;
            path.addAtom(nextAtom);
            path.addBond(bond);
            if (nextAtom == target) {
                return true;
            }
            if (!PathTools.depthFirstTargetSearch(molecule, nextAtom, target, path)) {
                path.removeAtom(nextAtom);
                path.removeBond(bond);
                continue;
            }
            return true;
        }
        return false;
    }

    @TestMethod(value="testBreadthFirstSearch_IAtomContainer_List_IAtomContainer")
    public static void breadthFirstSearch(IAtomContainer atomContainer, List<IAtom> sphere, IAtomContainer molecule) {
        PathTools.breadthFirstSearch(atomContainer, sphere, molecule, -1);
    }

    @TestMethod(value="testFindClosestByBond")
    public static IAtom[] findClosestByBond(IAtomContainer atomContainer, IAtom atom, int max) {
        IAtomContainer mol = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        ArrayList<IAtom> v = new ArrayList<IAtom>();
        v.add(atom);
        PathTools.breadthFirstSearch(atomContainer, v, mol, max);
        IAtom[] returnValue = new IAtom[mol.getAtomCount() - 1];
        int k = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (mol.getAtom(i) == atom) continue;
            returnValue[k] = mol.getAtom(i);
            ++k;
        }
        return returnValue;
    }

    @TestMethod(value="testBreadthFirstSearch_IAtomContainer_List_IAtomContainer_int")
    public static void breadthFirstSearch(IAtomContainer atomContainer, List<IAtom> sphere, IAtomContainer molecule, int max) {
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (IAtom atom : sphere) {
            molecule.addAtom(atom);
            List<ILonePair> lonePairs = atomContainer.getConnectedLonePairsList(atom);
            for (ILonePair lonePair : lonePairs) {
                molecule.addLonePair(lonePair);
            }
            List<ISingleElectron> singleElectrons = atomContainer.getConnectedSingleElectronsList(atom);
            for (ISingleElectron singleElectron : singleElectrons) {
                molecule.addSingleElectron(singleElectron);
            }
            List<IBond> bonds = atomContainer.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom;
                if (!bond.getFlag(16)) {
                    molecule.addBond(bond);
                    bond.setFlag(16, true);
                }
                if ((nextAtom = bond.getConnectedAtom(atom)).getFlag(16)) continue;
                newSphere.add(nextAtom);
                nextAtom.setFlag(16, true);
            }
            if (max <= -1 || molecule.getAtomCount() <= max) continue;
            return;
        }
        if (newSphere.size() > 0) {
            PathTools.breadthFirstSearch(atomContainer, newSphere, molecule, max);
        }
    }

    @TestMethod(value="testBreadthFirstTargetSearch_IAtomContainer_List_IAtom_int_int")
    public static int breadthFirstTargetSearch(IAtomContainer atomContainer, List<IAtom> sphere, IAtom target, int pathLength, int cutOff) {
        if (pathLength == 0) {
            PathTools.resetFlags(atomContainer);
        }
        if (++pathLength > cutOff) {
            return -1;
        }
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (IAtom atom : sphere) {
            List<IBond> bonds = atomContainer.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom;
                if (!bond.getFlag(16)) {
                    bond.setFlag(16, true);
                }
                if ((nextAtom = bond.getConnectedAtom(atom)).getFlag(16)) continue;
                if (nextAtom == target) {
                    return pathLength;
                }
                newSphere.add(nextAtom);
                nextAtom.setFlag(16, true);
            }
        }
        if (newSphere.size() > 0) {
            return PathTools.breadthFirstTargetSearch(atomContainer, newSphere, target, pathLength, cutOff);
        }
        return -1;
    }

    @TestMethod(value="testResetFlags_IAtomContainer")
    protected static void resetFlags(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            atomContainer.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            atomContainer.getBond(f).setFlag(16, false);
        }
    }

    @TestMethod(value="testGetMolecularGraphRadius_IAtomContainer")
    public static int getMolecularGraphRadius(IAtomContainer atomContainer) {
        int natom = atomContainer.getAtomCount();
        int[][] admat = AdjacencyMatrix.getMatrix(atomContainer);
        int[][] distanceMatrix = PathTools.computeFloydAPSP(admat);
        int[] eta = new int[natom];
        for (int i = 0; i < natom; ++i) {
            int max = -99999;
            for (int j = 0; j < natom; ++j) {
                if (distanceMatrix[i][j] <= max) continue;
                max = distanceMatrix[i][j];
            }
            eta[i] = max;
        }
        int min = 999999;
        for (int anEta : eta) {
            if (anEta >= min) continue;
            min = anEta;
        }
        return min;
    }

    @TestMethod(value="testGetMolecularGraphDiameter_IAtomContainer")
    public static int getMolecularGraphDiameter(IAtomContainer atomContainer) {
        int natom = atomContainer.getAtomCount();
        int[][] admat = AdjacencyMatrix.getMatrix(atomContainer);
        int[][] distanceMatrix = PathTools.computeFloydAPSP(admat);
        int[] eta = new int[natom];
        for (int i = 0; i < natom; ++i) {
            int max = -99999;
            for (int j = 0; j < natom; ++j) {
                if (distanceMatrix[i][j] <= max) continue;
                max = distanceMatrix[i][j];
            }
            eta[i] = max;
        }
        int max = -999999;
        for (int anEta : eta) {
            if (anEta <= max) continue;
            max = anEta;
        }
        return max;
    }

    @TestMethod(value="testGetVertexCountAtDistance_IAtomContainer_int")
    public static int getVertexCountAtDistance(IAtomContainer atomContainer, int distance) {
        int natom = atomContainer.getAtomCount();
        int[][] admat = AdjacencyMatrix.getMatrix(atomContainer);
        int[][] distanceMatrix = PathTools.computeFloydAPSP(admat);
        int n = 0;
        for (int i = 0; i < natom; ++i) {
            for (int j = 0; j < natom; ++j) {
                if (distanceMatrix[i][j] != distance) continue;
                ++n;
            }
        }
        return n / 2;
    }

    @TestMethod(value="testGetShortestPath_IAtomContainer_IAtom_IAtom")
    @Deprecated
    public static List<IAtom> getShortestPath(IAtomContainer atomContainer, IAtom start, IAtom end) {
        int natom = atomContainer.getAtomCount();
        int endNumber = atomContainer.getAtomNumber(end);
        int startNumber = atomContainer.getAtomNumber(start);
        int[] dist = new int[natom];
        int[] previous = new int[natom];
        for (int i = 0; i < natom; ++i) {
            dist[i] = 99999999;
            previous[i] = -1;
        }
        dist[atomContainer.getAtomNumber((IAtom)start)] = 0;
        ArrayList<IAtom> Slist = new ArrayList<IAtom>();
        ArrayList<Integer> Qlist = new ArrayList<Integer>();
        for (int i = 0; i < natom; ++i) {
            Qlist.add(i);
        }
        while (Qlist.size() != 0) {
            int u = 999999;
            int index = 0;
            for (Integer tmp : Qlist) {
                if (dist[tmp] >= u) continue;
                u = dist[tmp];
                index = tmp;
            }
            Qlist.remove(Qlist.indexOf(index));
            Slist.add(atomContainer.getAtom(index));
            if (index == endNumber) break;
            List<IAtom> connected = atomContainer.getConnectedAtomsList(atomContainer.getAtom(index));
            for (IAtom aConnected : connected) {
                int anum = atomContainer.getAtomNumber(aConnected);
                if (dist[anum] <= dist[index] + 1) continue;
                dist[anum] = dist[index] + 1;
                previous[anum] = index;
            }
        }
        ArrayList<IAtom> tmp = new ArrayList<IAtom>();
        int tmpSerial = endNumber;
        do {
            tmp.add(0, atomContainer.getAtom(tmpSerial));
        } while ((tmpSerial = previous[tmpSerial]) != startNumber);
        tmp.add(0, atomContainer.getAtom(tmpSerial));
        return tmp;
    }

    @TestMethod(value="testGetAllPaths_IAtomContainer_IAtom_IAtom")
    public static List<List<IAtom>> getAllPaths(IAtomContainer atomContainer, IAtom start, IAtom end) {
        ArrayList<List<IAtom>> allPaths = new ArrayList<List<IAtom>>();
        if (start.equals(end)) {
            return allPaths;
        }
        PathTools.findPathBetween(allPaths, atomContainer, start, end, new ArrayList<IAtom>());
        return allPaths;
    }

    private static void findPathBetween(List<List<IAtom>> allPaths, IAtomContainer atomContainer, IAtom start, IAtom end, List<IAtom> path) {
        if (start == end) {
            path.add(start);
            allPaths.add(new ArrayList<IAtom>(path));
            path.remove(path.size() - 1);
            return;
        }
        if (path.contains(start)) {
            return;
        }
        path.add(start);
        List<IAtom> nbrs = atomContainer.getConnectedAtomsList(start);
        for (IAtom nbr : nbrs) {
            PathTools.findPathBetween(allPaths, atomContainer, nbr, end, path);
        }
        path.remove(path.size() - 1);
    }

    @TestMethod(value="testGetPathsOfLength_IAtomContainer_IAtom_int")
    public static List<List<IAtom>> getPathsOfLength(IAtomContainer atomContainer, IAtom start, int length) {
        List curPath = new ArrayList<IAtom>();
        ArrayList<List<IAtom>> paths = new ArrayList<List<IAtom>>();
        curPath.add(start);
        paths.add(curPath);
        for (int i = 0; i < length; ++i) {
            ArrayList tmpList = new ArrayList();
            for (List list : paths) {
                curPath = list;
                IAtom lastVertex = (IAtom)curPath.get(curPath.size() - 1);
                List<IAtom> neighbors = atomContainer.getConnectedAtomsList(lastVertex);
                Iterator<IAtom> i$ = neighbors.iterator();
                while (i$.hasNext()) {
                    ArrayList<IAtom> newPath = new ArrayList<IAtom>(curPath);
                    IAtom neighbor = i$.next();
                    if (newPath.contains(neighbor)) continue;
                    newPath.add(neighbor);
                    tmpList.add(newPath);
                }
            }
            paths.clear();
            paths.addAll(tmpList);
        }
        return paths;
    }

    @TestMethod(value="testGetPathsOfLengthUpto")
    public static List<List<IAtom>> getPathsOfLengthUpto(IAtomContainer atomContainer, IAtom start, int length) {
        List curPath = new ArrayList<IAtom>();
        ArrayList<ArrayList<IAtom>> paths = new ArrayList<ArrayList<IAtom>>();
        ArrayList<List<IAtom>> allpaths = new ArrayList<List<IAtom>>();
        curPath.add(start);
        paths.add((ArrayList<IAtom>)curPath);
        allpaths.add(curPath);
        for (int i = 0; i < length; ++i) {
            ArrayList tmpList = new ArrayList();
            for (List list : paths) {
                curPath = list;
                IAtom lastVertex = (IAtom)curPath.get(curPath.size() - 1);
                List<IAtom> neighbors = atomContainer.getConnectedAtomsList(lastVertex);
                Iterator<IAtom> i$ = neighbors.iterator();
                while (i$.hasNext()) {
                    ArrayList<IAtom> newPath = new ArrayList<IAtom>(curPath);
                    IAtom neighbor = i$.next();
                    if (newPath.contains(neighbor)) continue;
                    newPath.add(neighbor);
                    tmpList.add(newPath);
                }
            }
            paths.clear();
            paths.addAll(tmpList);
            allpaths.addAll(tmpList);
        }
        return allpaths;
    }
}

