/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Iterator;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.MolecularFormulaSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugMolecularFormulaSet
extends MolecularFormulaSet
implements IMolecularFormulaSet {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugMolecularFormulaSet.class);

    public DebugMolecularFormulaSet() {
    }

    public DebugMolecularFormulaSet(IMolecularFormula formula) {
        super(formula);
    }

    @Override
    public void add(IMolecularFormulaSet formulaSet) {
        this.logger.debug("Adding formula set: ", formulaSet);
        super.add(formulaSet);
    }

    @Override
    public void addMolecularFormula(IMolecularFormula formula) {
        this.logger.debug("Adding formula: ", formula);
        super.addMolecularFormula(formula);
    }

    @Override
    public boolean contains(IMolecularFormula formula) {
        this.logger.debug("Contains formula?: ", formula);
        return super.contains(formula);
    }

    @Override
    public IMolecularFormula getMolecularFormula(int position) {
        this.logger.debug("Getting formula at: ", position);
        return super.getMolecularFormula(position);
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        this.logger.debug("Getting molecular formula iterator...");
        return super.iterator();
    }

    @Override
    public Iterable<IMolecularFormula> molecularFormulas() {
        this.logger.debug("Getting molecular formula iterable...");
        return super.molecularFormulas();
    }

    @Override
    public void removeAllMolecularFormulas() {
        this.logger.debug("Removing all formulas...");
        super.removeAllMolecularFormulas();
    }

    @Override
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.logger.debug("Removing this formula: ", formula);
        super.removeMolecularFormula(formula);
    }

    @Override
    public void removeMolecularFormula(int position) {
        this.logger.debug("Removing the formula at position: ", position);
        super.removeMolecularFormula(position);
    }

    @Override
    public int size() {
        this.logger.debug("Getting the size of this adduct: " + super.size());
        return super.size();
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

