/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Predicate;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;

public final class ComponentGrouping
implements Predicate<int[]> {
    public static final String KEY = "COMPONENT.GROUPING";
    private final int[] queryComponents;
    private final int[] targetComponents;
    private final ConnectedComponents cc;

    public ComponentGrouping(IAtomContainer query2, IAtomContainer target) {
        this(query2, GraphUtil.toAdjList(target));
    }

    public ComponentGrouping(IAtomContainer query2, int[][] target) {
        this(query2.getProperty(KEY, int[].class), query2.getProperty(KEY) != null ? new ConnectedComponents(target) : null);
    }

    public ComponentGrouping(int[] grouping, ConnectedComponents cc) {
        this.queryComponents = grouping;
        this.cc = cc;
        this.targetComponents = cc != null ? cc.components() : null;
    }

    @Override
    public boolean apply(int[] mapping) {
        if (this.queryComponents == null) {
            return true;
        }
        int[] usedBy = new int[this.cc.nComponents() + 1];
        int[] usedIn = new int[this.queryComponents[mapping.length] + 1];
        for (int v = 0; v < mapping.length; ++v) {
            if (this.queryComponents[v] == 0) continue;
            int w = mapping[v];
            int queryComponent = this.queryComponents[v];
            int targetComponent = this.targetComponents[w];
            if (usedBy[targetComponent] == 0) {
                usedBy[targetComponent] = queryComponent;
            } else if (usedBy[targetComponent] != queryComponent) {
                return false;
            }
            if (usedIn[queryComponent] == 0) {
                usedIn[queryComponent] = targetComponent;
                continue;
            }
            if (usedIn[queryComponent] == targetComponent) continue;
            return false;
        }
        return true;
    }
}

