/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractBondArray;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomArray;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLMolecule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLBondArray
extends AbstractBondArray {
    public static final String NS = "cml:bondArray";
    Map<String, CMLBond> bondIdMap;
    Map<String, CMLBond> bondMap;

    public CMLBondArray() {
        this.init();
    }

    private void init() {
        this.bondMap = new HashMap<String, CMLBond>();
        this.bondIdMap = new HashMap<String, CMLBond>();
    }

    public CMLBondArray(CMLBondArray old) {
        super(old);
        this.init();
    }

    @Override
    public Node copy() {
        return new CMLBondArray(this);
    }

    @Override
    public CMLBondArray makeElementInContext(Element parent) {
        CMLBondArray bondArray = new CMLBondArray();
        return bondArray;
    }

    @Override
    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
        this.indexBonds();
    }

    public CMLBond appendChild(CMLBond bond) {
        CMLBond bond0 = this.addBond(bond);
        return bond0;
    }

    public int size() {
        return this.getBondElements().size();
    }

    public CMLBond addBond(CMLBond bond) {
        int count = this.getChildCount();
        return this.insertBond(bond, count);
    }

    public CMLBond insertBond(CMLBond bond, int pos) {
        ParentNode parent = bond.getParent();
        CMLBond addedBond = null;
        if (parent != null) {
            if (parent.equals(this)) {
                throw new RuntimeException("bond already added " + bond.getString());
            }
        } else if (this.getMolecule() == null) {
            throw new RuntimeException("bondArray parent must be molecule");
        }
        this.insertChild(bond, pos);
        addedBond = this.indexBondAndLigands(bond);
        this.indexBondId(bond);
        return addedBond;
    }

    private CMLBond indexBondAndLigands(CMLBond bond) {
        CMLBond addedBond = null;
        String hash = CMLBond.atomHash(bond);
        if (hash != null) {
            if (this.bondMap.containsKey(hash)) {
                String molId = bond.getMolecule() == null ? null : bond.getMolecule().getId();
                throw new RuntimeException("bond already in array " + bond.getId() + "/" + hash + "/" + molId);
            }
            this.bondMap.put(hash, bond);
            addedBond = bond;
            bond.updateLigands();
        }
        return addedBond;
    }

    private void indexBondId(CMLBond bond) {
        String id = bond.getId();
        if (id != null && !"".equals(id.trim())) {
            if (this.bondIdMap.containsKey(id)) {
                throw new RuntimeException("bond already in id map " + bond.getId() + "/" + bond.getMolecule().getId());
            }
            this.bondIdMap.put(id, bond);
        }
    }

    public void indexBonds() {
        CMLMolecule molecule = this.getMolecule();
        if (molecule == null) {
            throw new RuntimeException("Cannot index bonds without molecule");
        }
        CMLAtomArray atomArray = molecule.getAtomArray();
        if (atomArray == null) {
            throw new RuntimeException("Cannot index bonds without atoms");
        }
        atomArray.clearLigandInfo();
        List<CMLBond> bonds = this.getBonds();
        this.bondMap.clear();
        this.bondIdMap.clear();
        for (CMLBond bond : bonds) {
            this.indexBondAndLigands(bond);
            this.indexBondId(bond);
        }
    }

    public CMLMolecule getMolecule() {
        CMLMolecule molecule = null;
        ParentNode parent = this.getParent();
        if (parent != null && parent instanceof CMLMolecule) {
            molecule = (CMLMolecule)parent;
        }
        return molecule;
    }

    private CMLAtomArray getAtomArray() {
        CMLMolecule molecule = this.getMolecule();
        return molecule == null ? null : molecule.getAtomArray();
    }

    void updateLigands() {
        List<CMLBond> bondList = this.getBonds();
        for (CMLBond bond : bondList) {
            bond.updateLigands();
        }
    }

    public CMLBond removeChild(CMLBond bond) {
        return this.removeBond(bond);
    }

    public CMLBond removeBond(CMLBond bond) {
        CMLBond deletedBond = null;
        if (bond != null && this.equals(bond.getParent())) {
            List<CMLAtom> atoms = bond.getAtoms();
            if (atoms != null) {
                int err = 0;
                if (atoms.size() == 2) {
                    try {
                        atoms.get(0).clearLigandInfo(bond, atoms.get(1));
                    }
                    catch (RuntimeException e) {
                        ++err;
                    }
                    try {
                        atoms.get(1).clearLigandInfo(bond, atoms.get(0));
                    }
                    catch (RuntimeException e) {
                        ++err;
                    }
                    if (err > 0) {
                        System.err.println("trouble removing ligands of " + bond.getString());
                    }
                }
            }
            super.removeChild(bond);
            this.getBondMap().remove(CMLBond.atomHash(bond));
            this.getBondIdMap().remove(bond.getId());
        }
        return deletedBond;
    }

    public Map<String, CMLBond> getBondMap() {
        if (this.bondMap == null) {
            this.bondMap = new HashMap<String, CMLBond>();
        }
        return this.bondMap;
    }

    public Map<String, CMLBond> getBondIdMap() {
        if (this.bondIdMap == null) {
            this.bondIdMap = new HashMap<String, CMLBond>();
        }
        return this.bondIdMap;
    }

    public List<CMLBond> getBonds() {
        ArrayList<CMLBond> bondList = new ArrayList<CMLBond>();
        CMLElements<CMLBond> bonds = this.getBondElements();
        for (CMLBond bond : bonds) {
            bondList.add(bond);
        }
        return bondList;
    }

    public CMLBond getBondByHash(String hash) {
        return this.bondMap.get(hash);
    }

    public CMLBond getBondByAtomRefs2(String[] atomRefs2) {
        return this.bondMap.get(CMLBond.atomHash(atomRefs2));
    }

    public CMLBond getBondById(String id) {
        return this.bondIdMap == null ? null : this.bondIdMap.get(id);
    }

    @Override
    public void detach() {
        ParentNode parent = this.getParent();
        if (parent != null && parent instanceof CMLMolecule) {
            CMLMolecule molecule = (CMLMolecule)parent;
            molecule.removeBondArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Message {
        NULL_BONDARRAY_PARENT("null bondArray parent");

        public String value;

        private Message(String s) {
            this.value = s;
        }
    }
}

