/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.setting;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.setting.IOSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionIOSetting
extends IOSetting {
    private List<String> settings;

    public OptionIOSetting(String name, IOSetting.Importance level, String question, List<String> settings, String defaultSetting) {
        super(name, level, question, defaultSetting);
        this.settings = settings;
        if (!this.settings.contains(defaultSetting)) {
            this.settings.add(defaultSetting);
        }
    }

    @Override
    public void setSetting(String setting) throws CDKException {
        if (!this.settings.contains(setting)) {
            throw new CDKException("Setting " + setting + " is not allowed.");
        }
        this.setting = setting;
    }

    public void setSetting(int setting) throws CDKException {
        if (setting >= this.settings.size() + 1 || setting <= 0) {
            throw new CDKException("Setting " + setting + " does not exist.");
        }
        this.setting = this.settings.get(setting - 1);
    }

    public List<String> getOptions() {
        return this.settings;
    }
}

