/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.type.ElectronImpactNBEReactionTest")
public class ElectronImpactNBEReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElectronImpactNBEReaction.class);

    @Override
    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#ElectronImpactNBE", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_IMoleculeSet")
    public IReactionSet initiate(IMoleculeSet reactants, IMoleculeSet agents) throws CDKException {
        logger.debug("initiate reaction: ElectronImpactNBEReaction");
        if (reactants.getMoleculeCount() != 1) {
            throw new CDKException("ElectronImpactNBEReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("ElectronImpactNBEReaction don't expects agents");
        }
        IReactionSet setOfReactions = DefaultChemObjectBuilder.getInstance().newInstance(IReactionSet.class, new Object[0]);
        IMolecule reactant = reactants.getMolecule(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atom : reactant.atoms()) {
            if (!atom.getFlag(10) || reactant.getConnectedLonePairsCount(atom) <= 0 || reactant.getConnectedSingleElectronsCount(atom) != 0) continue;
            ArrayList<IAtom> atomList = new ArrayList<IAtom>();
            atomList.add(atom);
            IMoleculeSet moleculeSet = reactant.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            moleculeSet.addMolecule(reactant);
            IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, null);
            if (reaction == null) continue;
            setOfReactions.addReaction(reaction);
        }
        return setOfReactions;
    }

    private void setActiveCenters(IMolecule reactant) throws CDKException {
        for (IAtom atom : reactant.atoms()) {
            if (reactant.getConnectedLonePairsCount(atom) <= 0 || reactant.getConnectedSingleElectronsCount(atom) != 0) continue;
            atom.setFlag(10, true);
        }
    }
}

