/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesXMLFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.pubchemxml.PubChemXMLHelper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class IteratingPCSubstancesXMLReader
extends DefaultIteratingChemObjectReader {
    private Reader primarySource;
    private XmlPullParser parser;
    private PubChemXMLHelper parserHelper;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemModel nextSubstance;

    public IteratingPCSubstancesXMLReader(Reader in, IChemObjectBuilder builder) throws IOException, XmlPullParserException {
        this.parserHelper = new PubChemXMLHelper(builder);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        this.parser = factory.newPullParser();
        this.primarySource = in;
        this.parser.setInput(this.primarySource);
        this.nextSubstance = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public IteratingPCSubstancesXMLReader(InputStream in, IChemObjectBuilder builder) throws Exception {
        this(new InputStreamReader(in), builder);
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PubChemSubstancesXMLFormat.getInstance();
    }

    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.parser.next() == 1) {
                    return false;
                }
                while (this.parser.next() != 1) {
                    if (this.parser.getEventType() != 2 || !"PC-Substance".equals(this.parser.getName())) continue;
                    this.hasNext = true;
                    break;
                }
                if (this.hasNext) {
                    this.nextSubstance = this.parserHelper.parseSubstance(this.parser);
                }
            }
            catch (Exception e) {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new RuntimeException("Error while parsing the XML: " + e.getMessage(), e);
                }
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextSubstance = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    public IChemObject next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextSubstance;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.primarySource.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.primarySource = reader;
        try {
            this.parser.setInput(this.primarySource);
        }
        catch (XmlPullParserException e) {
            throw new CDKException("Error while opening the input:" + e.getMessage(), e);
        }
        this.nextSubstance = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream reader) throws CDKException {
        this.setReader(new InputStreamReader(reader));
    }
}

