/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.FixedValuator;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.graph.query.VariableValues;
import java.util.HashSet;
import java.util.Set;

public interface Expression {
    public static final Expression TRUE = new BoolConstant(true);
    public static final Expression FALSE = new BoolConstant(false);

    public Valuator prepare(VariableIndexes var1);

    public boolean isVariable();

    public String getName();

    public boolean isConstant();

    public Object getValue();

    public boolean isApply();

    public String getFun();

    public int argCount();

    public Expression getArg(int var1);

    public static class BoolConstant
    extends Base
    implements Expression,
    Valuator {
        private boolean value;

        public BoolConstant(boolean value) {
            this.value = value;
        }

        public boolean isConstant() {
            return true;
        }

        public Object getValue() {
            return this.value ? Boolean.TRUE : Boolean.FALSE;
        }

        public Valuator prepare(VariableIndexes vi) {
            return this;
        }

        public boolean evalBool(VariableValues vv) {
            return this.value;
        }

        public boolean evalBool(IndexValues vv) {
            return this.value;
        }

        public Object evalObject(IndexValues iv) {
            return this.getValue();
        }
    }

    public static class Valof
    implements VariableValues {
        private VariableIndexes map;
        private IndexValues dom;

        public Valof(VariableIndexes map) {
            this.map = map;
        }

        public final Object get(String name) {
            return this.dom.get(this.map.indexOf(name));
        }

        public final Valof setDomain(IndexValues d) {
            this.dom = d;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Util {
        public static Set<String> variablesOf(Expression e) {
            return Util.addVariablesOf(new HashSet<String>(), e);
        }

        public static Set<String> addVariablesOf(Set<String> s, Expression e) {
            if (e.isVariable()) {
                s.add(e.getName());
            } else if (e.isApply()) {
                for (int i = 0; i < e.argCount(); ++i) {
                    Util.addVariablesOf(s, e.getArg(i));
                }
            }
            return s;
        }

        public static boolean containsAllVariablesOf(Set<String> variables, Expression e) {
            if (e.isConstant()) {
                return true;
            }
            if (e.isVariable()) {
                return variables.contains(e.getName());
            }
            if (e.isApply()) {
                for (int i = 0; i < e.argCount(); ++i) {
                    if (Util.containsAllVariablesOf(variables, e.getArg(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static boolean equals(Expression L, Expression R) {
            return L.isConstant() ? R.isConstant() && L.getValue().equals(R.getValue()) : (L.isVariable() ? R.isVariable() && R.getName().equals(R.getName()) : (L.isApply() ? R.isApply() && Util.sameApply(L, R) : false));
        }

        public static boolean sameApply(Expression L, Expression R) {
            return L.argCount() == R.argCount() && L.getFun().equals(R.getFun()) && Util.sameArgs(L, R);
        }

        public static boolean sameArgs(Expression L, Expression R) {
            for (int i = 0; i < L.argCount(); ++i) {
                if (Util.equals(L.getArg(i), R.getArg(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Application
    extends Base {
        public boolean isApply() {
            return true;
        }

        public abstract int argCount();

        public abstract String getFun();

        public abstract Expression getArg(int var1);
    }

    public static abstract class Variable
    extends Base {
        public boolean isVariable() {
            return true;
        }

        public abstract String getName();
    }

    public static class Fixed
    extends Constant {
        protected Object value;

        public Fixed(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public Valuator prepare(VariableIndexes vi) {
            return new FixedValuator(this.value);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static abstract class Constant
    extends Base {
        public boolean isConstant() {
            return true;
        }

        public abstract Object getValue();
    }

    public static abstract class Base
    implements Expression {
        public boolean isVariable() {
            return false;
        }

        public boolean isApply() {
            return false;
        }

        public boolean isConstant() {
            return false;
        }

        public String getName() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public int argCount() {
            return 0;
        }

        public String getFun() {
            return null;
        }

        public Expression getArg(int i) {
            return null;
        }

        public boolean equals(Object other) {
            return other instanceof Expression && Util.equals(this, (Expression)other);
        }
    }
}

