/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.QueryNodeFactoryBase;
import com.hp.hpl.jena.shared.BrokenException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryNode {
    public static final int NO_INDEX = -1;
    public final Node node;
    public final int index;
    public static final QueryNodeFactory factory = new QueryNodeFactoryBase();

    protected QueryNode(Node node) {
        this(node, -1);
    }

    protected QueryNode(Node node, int index) {
        this.node = node;
        this.index = index;
    }

    public String toString() {
        return this.node.toString() + "[" + this.index + "]";
    }

    public boolean isFrozen() {
        return true;
    }

    public Node finder(Domain d) {
        return Node.ANY;
    }

    public boolean mustMatch() {
        return false;
    }

    public boolean match(Domain d, Node x) {
        throw new MustNotMatchException("QueryNode " + this + " cannot match");
    }

    public abstract boolean matchOrBind(Domain var1, Node var2);

    public static QueryNode classify(QueryNodeFactory f, Mapping map, Set<Node> recent, Node n) {
        if (n.equals(Node.ANY)) {
            return f.createAny();
        }
        if (n.isVariable()) {
            if (map.hasBound(n)) {
                if (recent.contains(n)) {
                    return f.createJustBound(n, map.indexOf(n));
                }
                return f.createBound(n, map.indexOf(n));
            }
            recent.add(n);
            return f.createBind(n, map.newIndex(n));
        }
        return new Fixed(n);
    }

    public static class Any
    extends QueryNode {
        public Any() {
            super(Node.ANY);
        }

        public boolean matchOrBind(Domain d, Node x) {
            return true;
        }

        public String toString() {
            return "ANY";
        }
    }

    public static class Bound
    extends QueryNode {
        public Bound(Node n, int index) {
            super(n, index);
        }

        public Node finder(Domain d) {
            return d.getElement(this.index);
        }

        public boolean matchOrBind(Domain d, Node x) {
            return d.getElement(this.index).matches(x);
        }

        public String toString() {
            return this.node.toString() + "[bound " + this.index + "]";
        }
    }

    public static class JustBound
    extends QueryNode {
        public JustBound(Node n, int index) {
            super(n, index);
        }

        public boolean mustMatch() {
            return true;
        }

        public boolean isFrozen() {
            return false;
        }

        public boolean match(Domain d, Node X) {
            return X.matches(d.getElement(this.index));
        }

        public boolean matchOrBind(Domain d, Node x) {
            return x.matches(d.getElement(this.index));
        }

        public String toString() {
            return this.node.toString() + "[just " + this.index + "]";
        }
    }

    public static class Bind
    extends QueryNode {
        public Bind(Node n, int index) {
            super(n, index);
        }

        public boolean mustMatch() {
            return true;
        }

        public boolean isFrozen() {
            return false;
        }

        public boolean match(Domain d, Node value) {
            d.setElement(this.index, value);
            return true;
        }

        public boolean matchOrBind(Domain d, Node value) {
            d.setElement(this.index, value);
            return true;
        }

        public String toString() {
            return this.node.toString() + "[bind " + this.index + "]";
        }
    }

    public static class Fixed
    extends QueryNode {
        public Fixed(Node n) {
            super(n);
        }

        public Node finder(Domain d) {
            return this.node;
        }

        public boolean matchOrBind(Domain d, Node x) {
            return this.node.matches(x);
        }

        public String toString() {
            return this.node.toString() + "[fixed]";
        }
    }

    public class MustNotMatchException
    extends BrokenException {
        public MustNotMatchException(String message) {
            super(message);
        }
    }
}

