/*
 * Decompiled with CFR 0.152.
 */
package signature.simple;

import junit.framework.Assert;
import org.junit.Test;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.SymmetryClass;
import signature.simple.SimpleGraph;
import signature.simple.SimpleGraphBuilder;
import signature.simple.SimpleGraphFactory;
import signature.simple.SimpleGraphSignature;

public class ReconstructionTest {
    public void reconstruct(SimpleGraph graph) {
        SimpleGraphSignature signature = new SimpleGraphSignature(graph);
        for (SymmetryClass symmetryClass : signature.getSymmetryClasses()) {
            String signatureString = symmetryClass.getSignatureString();
            ColoredTree tree = AbstractVertexSignature.parse(signatureString);
            SimpleGraphBuilder builder = new SimpleGraphBuilder();
            SimpleGraph reconstruction = builder.fromTree(tree);
            Assert.assertEquals((String)reconstruction.toString(), (String)graph.toString());
        }
    }

    @Test
    public void petersensGraphTest() {
        SimpleGraph petersens = SimpleGraphFactory.makePetersensGraph();
    }

    @Test
    public void bowtieaneTest() {
        SimpleGraph bowtie = SimpleGraphFactory.makeBowtieane();
        String tmp = new SimpleGraphSignature(bowtie).signatureStringForVertex(6);
        System.out.println(tmp);
        System.out.println("----------------------------------------");
        String tmp2 = new SimpleGraphSignature(bowtie).signatureStringForVertex(2);
        System.out.println(tmp2);
    }
}

